/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import com.browsersoft.config.utils.StreamUtils;
import com.browsersoft.config.utils.XTrustProvider;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final int READ_TIMEOUT = 500;
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static byte[] sendBytes(String url, byte[] bytes) throws Exception {
        URL urlO = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)urlO.openConnection();
        connection.setUseCaches(false);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-Length", String.valueOf(bytes.length));
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestMethod("POST");
        HttpUtils.skipSllHostnamecheck(urlO, connection);
        OutputStream outputStream = connection.getOutputStream();
        outputStream.write(bytes);
        outputStream.close();
        InputStream in = connection.getInputStream();
        return StreamUtils.loadInputStreamToBytes(in);
    }

    protected static void skipSllHostnamecheck(URL url, HttpURLConnection connection) throws GeneralSecurityException {
        if (!url.getProtocol().equalsIgnoreCase("https")) {
            return;
        }
        if (!(connection instanceof HttpsURLConnection)) {
            return;
        }
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection sslConnection = (HttpsURLConnection)connection;
        sslConnection.setSSLSocketFactory(HttpUtils.getNoCheckSslSocketFactory());
        sslConnection.setHostnameVerifier(allHostsValid);
    }

    private static SSLSocketFactory getNoCheckSslSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext context = SSLContext.getInstance("TLSv1");
        XTrustProvider.TrustManagerFactoryImpl trustManagerFactorySpi = new XTrustProvider.TrustManagerFactoryImpl();
        context.init(null, trustManagerFactorySpi.getTrustManagers(), new SecureRandom());
        return context.getSocketFactory();
    }

    public static String openURL(String URL2, boolean debug) throws IOException {
        try {
            if (debug) {
                log.debug("Opening URL:" + URL2);
            }
            if (URL2.toLowerCase().startsWith("https")) {
                HostnameVerifier hv = new HostnameVerifier(){

                    @Override
                    public boolean verify(String urlHostName, SSLSession session) {
                        return true;
                    }
                };
                HttpUtils.trustAllHttpsCertificates();
                HttpsURLConnection.setDefaultHostnameVerifier(hv);
            }
            URL myCM = new URL(URL2);
            HttpURLConnection connection = (HttpURLConnection)myCM.openConnection();
            connection.setRequestMethod("GET");
            connection.setReadTimeout(500);
            connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 7.0b; Windows NT 6.0)");
            InputStream inputStream = connection.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamUtils.inputStreamToOutputStream(inputStream, byteArrayOutputStream);
            inputStream.close();
            connection.disconnect();
            return new String(byteArrayOutputStream.toByteArray(), "UTF8");
        }
        catch (SocketTimeoutException e) {
            String message = "Request " + URL2 + " timed out";
            throw new IOException(message);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static InputStream downloadURL(String URL2) throws IOException {
        if (URL2.toLowerCase().startsWith("https")) {
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            };
            try {
                HttpUtils.trustAllHttpsCertificates();
            }
            catch (Exception e) {
                log.warn("Could not download", (Throwable)e);
            }
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        URL myCM = new URL(URL2);
        HttpURLConnection connection = (HttpURLConnection)myCM.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 7.0b; Windows NT 6.0)");
        return connection.getInputStream();
    }

    public static byte[] downloadURL(String URL2, boolean debug) throws IOException {
        try {
            log.debug("Opening URL:" + URL2);
            if (URL2.toLowerCase().startsWith("https")) {
                HostnameVerifier hv = new HostnameVerifier(){

                    @Override
                    public boolean verify(String urlHostName, SSLSession session) {
                        return true;
                    }
                };
                HttpUtils.trustAllHttpsCertificates();
                HttpsURLConnection.setDefaultHostnameVerifier(hv);
            }
            URL myCM = new URL(URL2);
            HttpURLConnection connection = (HttpURLConnection)myCM.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 7.0b; Windows NT 6.0)");
            InputStream inputStream = connection.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamUtils.inputStreamToOutputStream(inputStream, byteArrayOutputStream);
            inputStream.close();
            connection.disconnect();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            log.debug("Error", (Throwable)e);
            throw new IOException(e);
        }
    }

    public static void redirectURLToOutputStream(String URL2, OutputStream out) throws Exception {
        URL myCM = new URL(URL2);
        HttpURLConnection connection = (HttpURLConnection)myCM.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 7.0b; Windows NT 6.0)");
        InputStream inputStream = connection.getInputStream();
        StreamUtils.inputStreamToOutputStream(inputStream, out);
        inputStream.close();
        connection.disconnect();
    }

    public static String postData(String urlstr, String parameters, Map<String, String> httpRequestProperties) throws IOException {
        URL url = new URL(urlstr);
        HttpURLConnection hpcon = null;
        try {
            String input;
            hpcon = (HttpURLConnection)url.openConnection();
            hpcon.setRequestMethod("POST");
            hpcon.setRequestProperty("Content-Length", Integer.toString(parameters.getBytes("UTF-8").length));
            if (httpRequestProperties != null) {
                for (Map.Entry<String, String> entry : httpRequestProperties.entrySet()) {
                    hpcon.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            hpcon.setDoOutput(true);
            OutputStream out = hpcon.getOutputStream();
            out.write(parameters.getBytes("UTF-8"));
            out.flush();
            out.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(hpcon.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((input = in.readLine()) != null) {
                response.append(input).append("\r");
            }
            String string = response.toString();
            return string;
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
            throw new IOException(e.getMessage());
        }
        finally {
            if (hpcon != null) {
                hpcon.disconnect();
            }
        }
    }

    public static String sendData(String host, int port, String data) throws IOException {
        Socket socket = null;
        try {
            socket = new Socket(host, port);
            OutputStream out = socket.getOutputStream();
            InputStream inputStream = socket.getInputStream();
            out.write(data.getBytes());
            out.flush();
            StringBuffer response = new StringBuffer();
            try {
                int c;
                while ((c = inputStream.read()) != -1) {
                    response.append((char)c);
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                // empty catch block
            }
            out.close();
            String string = response.toString();
            return string;
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
            throw new IOException(e.getMessage());
        }
        finally {
            if (socket != null && !socket.isClosed()) {
                socket.close();
            }
        }
    }

    public static void trustAllHttpsCertificates() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[1];
        miTM tm = new miTM();
        trustAllCerts[0] = tm;
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    public static class miTM
    implements TrustManager,
    X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

