/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import com.browsersoft.config.utils.RuntimeUtils;
import java.io.File;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaVersionChecker {
    private static final Logger logger = LoggerFactory.getLogger(JavaVersionChecker.class);

    public static String getJavaVersion(String pathToJavaBinDir) throws Exception {
        String[] lines;
        if (pathToJavaBinDir == null || pathToJavaBinDir.isEmpty()) {
            return "";
        }
        String fileExtension = System.getProperty("os.name").toLowerCase().contains("win") ? ".exe" : "";
        String javaExecutablePath = pathToJavaBinDir + System.getProperty("file.separator") + "java" + fileExtension;
        String[] commandArr = new String[]{javaExecutablePath, "-version"};
        for (String line : lines = RuntimeUtils.runCmdSync(commandArr, new File("./")).split("\n")) {
            if (!line.contains("version")) continue;
            logger.debug("Trying to find Java major version in string \"{}\"", (Object)line);
            String[] words = line.split(" ");
            if (words.length < 2) {
                return "";
            }
            String versionString = words[2].replaceAll("\"", "");
            String[] versionParts = versionString.split("\\.");
            if (versionParts.length < 1) {
                return "";
            }
            return versionParts[0];
        }
        return "";
    }

    public static String checkJavaVersion(String actualVersion, String supportedVersionString) {
        if (supportedVersionString == null || supportedVersionString.isEmpty()) {
            return "";
        }
        String[] supportedVersions = supportedVersionString.split(";");
        if (actualVersion == null || actualVersion.isEmpty()) {
            return "";
        }
        for (String version : supportedVersions) {
            if (!Objects.equals(version, actualVersion)) continue;
            return "";
        }
        return actualVersion + ":" + supportedVersionString;
    }

    public static String getJavaMajorVersion() {
        String[] resultSplitByDots = System.getProperty("java.version").split("[.]");
        if (resultSplitByDots.length > 0) {
            if (resultSplitByDots[0].equals("1")) {
                return resultSplitByDots[1];
            }
            return resultSplitByDots[0];
        }
        return "";
    }
}

