/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class NestedJarsClassLoader
extends ClassLoader {
    private final Map<String, URL> resources = new HashMap<String, URL>();
    private final Map<String, byte[]> byteCache = new HashMap<String, byte[]>();
    private final Map<String, Class<?>> classes = new HashMap();

    public NestedJarsClassLoader() {
    }

    public NestedJarsClassLoader(URL[] urls) throws IOException {
        this.addURLs(urls);
    }

    public NestedJarsClassLoader(ClassLoader parent, URL[] urls) throws IOException {
        super(parent);
        this.addURLs(urls);
    }

    public void addURLs(URL ... urls) throws IOException {
        for (URL url : urls) {
            this.addResource(url);
        }
    }

    private void addResource(URL url) throws IOException {
        if (!url.toString().endsWith(".jar")) {
            throw new IOException(url.toString() + " is not jar file!");
        }
        try (JarInputStream jarInputStream = new JarInputStream(new BufferedInputStream(url.openStream()));){
            JarEntry jarEntry;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                Object spec = url.getProtocol().equals("jar") ? url.getPath() : url.getProtocol() + ":" + url.getPath();
                URL jarEntryUrl = new URL("jar:" + (String)spec + "!/" + jarEntry.getName());
                this.resources.put(jarEntry.getName(), jarEntryUrl);
                if (!jarEntry.getName().endsWith(".class")) continue;
                this.addClass(jarEntry.getName(), jarInputStream);
            }
        }
    }

    @Override
    public synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.classes.containsKey(name)) {
                return this.classes.get(name);
            }
            if (this.byteCache.containsKey(name)) {
                byte[] bytes = this.byteCache.get(name);
                Class<?> loadedClass = this.defineClass(name, bytes, 0, bytes.length, this.getClass().getProtectionDomain());
                this.classes.put(name, loadedClass);
                return loadedClass;
            }
            throw new ClassNotFoundException(name);
        }
    }

    @Override
    public URL getResource(String name) {
        if (this.resources.containsKey(name)) {
            return this.resources.get(name);
        }
        return super.getResource(name);
    }

    private void addClass(String path, InputStream inputStream) throws IOException {
        String className = this.pathToClassName(path);
        byte[] data = this.readInputStream(inputStream);
        this.byteCache.put(className, data);
    }

    private String pathToClassName(String path) {
        return path.substring(0, path.lastIndexOf(".class")).replace("/", ".");
    }

    private byte[] readInputStream(InputStream inputStream) throws IOException {
        int len;
        byte[] buffer = new byte[2048];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.close();
        return out.toByteArray();
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        NestedJarsClassLoader loader = new NestedJarsClassLoader();
        loader.addURLs(new URL("jar:file:/data/workspace/lightbeam/configurator/build/libraries/internal/selenium.jar!/com/browsersoft/selenium/jars/client-combined-3.141.59.jar"));
        Class<?> clazz = loader.findClass("org.openqa.selenium.WebDriver");
        System.out.println("Clazz: " + clazz.getCanonicalName());
    }
}

