/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import com.browsersoft.config.utils.ProcessOutHandler;
import com.browsersoft.config.utils.SimpleLiningProcessOutHandler;
import com.browsersoft.config.utils.StartConsumer;
import com.browsersoft.config.utils.StringUtils;
import com.browsersoft.config.utils.streams.StreamGobbler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;

public class RuntimeUtils {
    private static final Logger logger = Logger.getLogger(RuntimeUtils.class.getName());

    public static String runCmdAsync(String[] cmdArr, Map<String, String> envp, File dir) throws Exception {
        String line;
        String[] env = null;
        if (envp != null) {
            HashMap<String, String> envs = new HashMap<String, String>(System.getenv());
            for (Map.Entry<String, String> entry : envp.entrySet()) {
                envs.put(entry.getKey(), entry.getValue());
            }
            int i = 0;
            env = new String[envs.size()];
            for (Map.Entry entry : envs.entrySet()) {
                env[i] = (String)entry.getKey() + "=" + (String)entry.getValue();
                ++i;
            }
        }
        Process pr = new ProcessBuilder(new String[0]).command(cmdArr).inheritIO().start();
        BufferedReader input = null;
        Object var6_10 = null;
        StringBuilder stringBuilder = new StringBuilder();
        input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        while ((line = input.readLine()) != null) {
            stringBuilder.append(line).append("\n");
        }
        return stringBuilder.toString();
    }

    public static String runCmdSync(String[] cmdArr, File dir) throws IOException {
        return RuntimeUtils.runCmdSync(cmdArr, null, dir);
    }

    public static String runCmdSync(String[] cmdArr, Map<String, String> envp, File dir) throws IOException {
        return RuntimeUtils.runCmdSync(StringUtils.arrayToString(cmdArr, " "), envp, dir, null);
    }

    public static String runCmdSync(String cmd, File dir) throws IOException {
        return RuntimeUtils.runCmdSync(cmd, null, dir, null);
    }

    public static String runCmdSync(String cmd, Map<String, String> envp, File dir, List<Consumer<Process>> startConsumers) throws IOException {
        CommandLine commandLine = CommandLine.parse((String)cmd);
        DefaultExecutor executor = new DefaultExecutor();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)outputStream);
        executor.setWorkingDirectory(dir);
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        if (startConsumers != null && startConsumers.size() > 0) {
            executor.setWatchdog((ExecuteWatchdog)new StartConsumer(startConsumers));
        }
        try {
            executor.execute(commandLine, envp);
        }
        catch (Exception e) {
            throw new IOException("Error while running cmd. Output:\n" + outputStream, e);
        }
        String s = outputStream.toString();
        return s;
    }

    public static void runCmdSync(String cmdArr, File dir, OutputStream outputStream) throws Exception {
        CommandLine commandLine = CommandLine.parse((String)cmdArr);
        DefaultExecutor executor = new DefaultExecutor();
        PumpStreamHandler streamHandler = new PumpStreamHandler(outputStream);
        executor.setWorkingDirectory(dir);
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        executor.execute(commandLine);
    }

    public static int runCmd(String[] cmdArr, Map<String, String> envp, File dir, ProcessOutHandler outHandler) throws Exception {
        return RuntimeUtils.runCmd(cmdArr, envp, dir, outHandler, null);
    }

    public static int runCmd(String[] cmdArr, Map<String, String> envp, File dir, ProcessOutHandler outHandler, String input) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (envp != null) {
            processBuilder.environment().putAll(envp);
        }
        processBuilder.directory(dir);
        processBuilder.command(cmdArr);
        Process p = processBuilder.start();
        if (input != null) {
            Thread stdInThread = new Thread(() -> {
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));){
                    writer.write(input);
                    ((Writer)writer).flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }, "StdInWriter");
            stdInThread.start();
        }
        SimpleLiningProcessOutHandler lOutHandler = new SimpleLiningProcessOutHandler(outHandler);
        StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), lOutHandler::writeOut);
        StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), lOutHandler::writeErr);
        new Thread((Runnable)outputGobbler, "Process out gobbler").start();
        new Thread((Runnable)errorGobbler, "Process err gobbler").start();
        p.waitFor();
        return p.exitValue();
    }
}

