/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import com.browsersoft.config.utils.streams.SizedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtils {
    private static final Logger logger = LoggerFactory.getLogger(StreamUtils.class);
    private static int c = 0;

    public static byte[] serializeObjectToByteArray(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objStream = new ObjectOutputStream(byteArrayOutputStream);
        objStream.writeObject(object);
        objStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserializeByteArrayToObject(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public static byte[] unzip(InputStream in) throws Exception {
        int c;
        GZIPInputStream zipInputStream = new GZIPInputStream(in);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((c = zipInputStream.read()) != -1) {
            byteArrayOutputStream.write((char)c);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static InputStream zip(byte[] bytes) throws IOException {
        int c;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream out = new GZIPOutputStream(byteArrayOutputStream);
        while ((c = in.read()) != -1) {
            out.write((char)c);
        }
        out.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public static byte[] loadInputStreamToBytes(InputStream in) throws IOException {
        int c;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        while ((c = in.read(buffer, 0, buffer.length)) != -1) {
            byteArrayOutputStream.write(buffer, 0, c);
        }
        in.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static String getExceptionStackAsHTML(Throwable ex) {
        String retval = StreamUtils.getExceptionStack(ex);
        retval = retval.replaceAll("(\r\n|\r|\n|\n\r)", "<br>\n");
        retval = retval.replaceAll("(\t)", "&nbsp;\t");
        return retval;
    }

    public static String getExceptionStack(Throwable ex) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream((OutputStream)bos, false, "UTF-8");
            ex.printStackTrace(ps);
            byte[] data = bos.toByteArray();
            return new String(data, "UTF-8");
        }
        catch (Exception ex2) {
            logger.warn("", ex);
            logger.warn("", (Throwable)ex2);
            return "Exception occured: " + ex.getLocalizedMessage();
        }
    }

    public static void tmp_exceptionThrower() {
        if (++c % 3 == 0) {
            throw new RuntimeException("test exception");
        }
    }

    public static void inputStreamToOutputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        long limit = -1L;
        if (inputStream instanceof SizedInputStream) {
            limit = ((SizedInputStream)inputStream).getSize();
        }
        StreamUtils.inputStreamToOutputStream(inputStream, outputStream, limit);
    }

    public static void inputStreamToOutputStream(InputStream inputStream, OutputStream outputStream, long limit) throws IOException {
        int read;
        long remaining = limit;
        int bufferSize = 2048;
        if (limit > -1L && limit < (long)bufferSize) {
            bufferSize = (int)limit;
        }
        byte[] buffer = new byte[bufferSize];
        while ((read = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, read);
            if (limit <= -1L) continue;
            if ((remaining -= (long)read) == 0L) break;
            if (remaining >= (long)bufferSize) continue;
            buffer = new byte[(int)remaining];
        }
    }
}

