/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import java.util.Comparator;

public class VersionStringsComparator
implements Comparator {
    public static void main(String[] args) {
        String[][] data = new String[][]{{"1.2.3", "1.2.3"}, {"1.2.3", "1.2.4"}, {"1.2.4", "1.2.3"}, {"1.2.3", "1.2.3.1"}, {"2020.2.3.1", "1.2.3"}, {"10.2.3.A", "1.2.3.B"}};
        VersionStringsComparator c = new VersionStringsComparator();
        for (String[] item : data) {
            int res = c.compare(item[0], item[1]);
            String sign = "=";
            if (res < 0) {
                sign = ">";
            } else if (res > 0) {
                sign = "<";
            }
            System.out.println(item[0] + " " + sign + " " + item[1]);
        }
    }

    public int compare(Object v1, Object v2) {
        return this.compareVersionStrings((String)v1, (String)v2);
    }

    public int compareVersionStrings(String v1, String v2) {
        String[] v2Parts;
        String[] v1Parts = v1.split("\\.");
        int num = v1Parts.length > (v2Parts = v2.split("\\.")).length ? v1Parts.length : v2Parts.length;
        for (int i = 0; i < num; ++i) {
            if (v1Parts.length <= i) {
                return 1;
            }
            if (v2Parts.length <= i) {
                return -1;
            }
            String v1Part = v1Parts[i];
            String v2Part = v2Parts[i];
            if (this.isNumeric(v1Part) && this.isNumeric(v2Part)) {
                int v2Num;
                int v1Num = Integer.valueOf(v1Part);
                if (v1Num == (v2Num = Integer.valueOf(v2Part).intValue())) continue;
                return v2Num - v1Num;
            }
            int res = v2Part.compareTo(v1Part);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    protected boolean isNumeric(String str) {
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }
}

