/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import com.browsersoft.config.utils.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static byte[] zipDirWithDiffRoot(String dir, String rootName) throws Exception {
        File dirObj = new File(dir);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ZipOutputStream out = new ZipOutputStream(byteArrayOutputStream);){
            ZipUtil.addDir(dirObj, rootName, out);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String getNameOfEntryWithoutFolderNames(ZipEntry e) {
        String[] split = e.getName().split("/");
        return split[split.length - 1];
    }

    public static byte[] zipDir(String dir) throws Exception {
        File dirObj = new File(dir);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ZipOutputStream out = new ZipOutputStream(byteArrayOutputStream);){
            ZipUtil.addDir(dirObj, "", out);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void zipDir(String dir, OutputStream outputStream) throws Exception {
        File dirObj = new File(dir);
        try (ZipOutputStream out = new ZipOutputStream(outputStream);){
            ZipUtil.addDir(dirObj, dirObj.getName(), out);
        }
    }

    static void addDir(File dirObj, String relative, ZipOutputStream out) throws IOException {
        File[] files = dirObj.listFiles();
        if (files == null) {
            return;
        }
        byte[] tmpBuf = new byte[1024];
        Object prefix = "";
        if (!relative.equals("")) {
            prefix = relative + "/";
        }
        for (File file : files) {
            if (file.isDirectory()) {
                ZipEntry zipEntry = new ZipEntry((String)prefix + file.getName() + "/");
                zipEntry.setTime(file.lastModified());
                out.putNextEntry(zipEntry);
                ZipUtil.addDir(file, (String)prefix + file.getName(), out);
                continue;
            }
            try (FileInputStream in = new FileInputStream(file.getAbsolutePath());){
                int len;
                ZipEntry zipEntry = new ZipEntry((String)prefix + file.getName());
                zipEntry.setTime(file.lastModified());
                out.putNextEntry(zipEntry);
                while ((len = in.read(tmpBuf)) > 0) {
                    out.write(tmpBuf, 0, len);
                }
                out.closeEntry();
            }
        }
    }

    public static void unpackZip(byte[] bytes, File destination) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            ZipUtil.unpackZip(in, destination, false);
        }
    }

    public static void unpackZip(InputStream inputStream, File destination, boolean makeParents) throws IOException {
        try (ZipInputStream zin = new ZipInputStream(inputStream);){
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                File file = new File(destination, ze.getName());
                if (ze.isDirectory()) {
                    file.mkdir();
                    zin.closeEntry();
                    continue;
                }
                if (makeParents) {
                    file.getParentFile().mkdirs();
                }
                try (FileOutputStream fout = new FileOutputStream(file);){
                    int r;
                    byte[] buf = new byte[4096];
                    while ((r = zin.read(buf)) != -1) {
                        fout.write(buf, 0, r);
                    }
                    zin.closeEntry();
                }
            }
        }
    }

    public static void unpackZip(File file, File destication) throws IOException {
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (entry.isDirectory()) continue;
                File outFile = new File(destication, entry.getName());
                outFile.getParentFile().mkdirs();
                InputStream in = zip.getInputStream(entry);
                try (FileOutputStream out = new FileOutputStream(outFile);){
                    ZipUtil.inputStreamToOutputStream(in, out, 2000);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
    }

    public static List<File> unpackZipWithReturnEntries(File file, File destication) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (entry.isDirectory()) continue;
                File outFile = new File(destication, entry.getName());
                files.add(outFile);
                outFile.getParentFile().mkdirs();
                InputStream in = zip.getInputStream(entry);
                try (FileOutputStream out = new FileOutputStream(outFile);){
                    ZipUtil.inputStreamToOutputStream(in, out, 2000);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        return files;
    }

    public static byte[] unpackZipEntry(InputStream in, String entryName) throws IOException {
        ZipEntry entry;
        ZipInputStream zip = new ZipInputStream(in);
        while ((entry = zip.getNextEntry()) != null && !entry.getName().equals(entryName)) {
        }
        if (entry == null) {
            return null;
        }
        return StreamUtils.loadInputStreamToBytes(zip);
    }

    public static void inputStreamToOutputStream(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        int length;
        byte[] buffer = new byte[bufferSize];
        while ((length = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, length);
        }
        outputStream.close();
        inputStream.close();
    }

    public static InputStream openInputStream(ZipEntry zipEntry, InputStream inputStream) throws Exception {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(inputStream);
        while ((entry = zis.getNextEntry()) != null) {
            if (!entry.getName().equals(zipEntry.getName())) continue;
            return zis;
        }
        return null;
    }

    public static List<ZipEntry> getZipEntriesInEntry(ZipFile zipFile, String path) {
        ArrayList<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String name = ZipUtil.getNameWithoutSlash(zipEntry.getName());
            if (ZipUtil.getNumberOfSlashs(path) != ZipUtil.getNumberOfSlashs(name) || path.equals(name) || !name.startsWith(path)) continue;
            zipEntries.add(zipEntry);
        }
        return zipEntries;
    }

    public static List<ZipEntry> getZipEntriesInEntryDeep(ZipFile zipFile, ZipEntry entry) {
        ArrayList<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
        zipEntries.add(entry);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String name = ZipUtil.getNameWithoutSlash(zipEntry.getName());
            if (ZipUtil.getNumberOfSlashs(entry.getName()) > ZipUtil.getNumberOfSlashs(name) || entry.getName().equals(name) || !name.startsWith(entry.getName())) continue;
            zipEntries.add(zipEntry);
        }
        return zipEntries;
    }

    public static int getNumberOfSlashs(String s) {
        int counter = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '/') continue;
            ++counter;
        }
        return counter;
    }

    public static String getNameWithoutSlash(String name) {
        if (name.endsWith("/")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static void zipFolder(File srcFolder, File destZipFile) throws Exception {
        File[] files = srcFolder.listFiles();
        if (files == null) {
            return;
        }
        try (FileOutputStream fileWriter = new FileOutputStream(destZipFile);
             ZipOutputStream zip = new ZipOutputStream(fileWriter);){
            for (File file : files) {
                ZipUtil.addFileToZip("", file.getAbsolutePath(), zip);
            }
        }
    }

    private static void addFileToZip(String path, String srcFile, ZipOutputStream zip) throws Exception {
        File file = new File(srcFile);
        if (file.isDirectory()) {
            ZipUtil.addFolderToZip(path, srcFile, zip);
        } else {
            Object entryName = file.getName();
            if (path != null && !path.isEmpty()) {
                entryName = path + "/" + (String)entryName;
            }
            try (FileInputStream in = new FileInputStream(srcFile);){
                int len;
                zip.putNextEntry(new ZipEntry((String)entryName));
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
        }
    }

    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws Exception {
        File folder = new File(srcFolder);
        String[] files = folder.list();
        if (files == null) {
            return;
        }
        for (String fileName : files) {
            Object entryName = folder.getName();
            if (path != null && !path.isEmpty()) {
                entryName = path + "/" + (String)entryName;
            }
            ZipUtil.addFileToZip((String)entryName, srcFolder + "/" + fileName, zip);
        }
    }

    public static byte[] getZipEntryAsBytes(ZipFile zipFile, String entryName) throws IOException {
        byte[] result = new byte[]{};
        if (zipFile == null) {
            return result;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().equals(entryName)) continue;
            try (InputStream in = zipFile.getInputStream(entry);){
                result = StreamUtils.loadInputStreamToBytes(in);
                break;
            }
        }
        return result;
    }
}

