/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils.logger;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import com.browsersoft.config.utils.DOMUtils;
import java.util.LinkedList;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class ConfiguratorLoggerFactory {
    private static String logFile = "output.log";
    private static String loggingPattern = "%d{HH:mm:ss} [%p] %class{0}.%method:%L - %m%n";
    private static int numberOfGatheredLogFiles = 30;
    private static String rotateLogPattern = "logs/logfile-%d{yyyy-MM-dd_HH}.log";
    private static boolean stdout = false;
    private static Level level = Level.INFO;

    public void init(Level level, String loggingPattern, boolean stdout) {
        ConfiguratorLoggerFactory.loggingPattern = loggingPattern;
        ConfiguratorLoggerFactory.level = level;
        ConfiguratorLoggerFactory.stdout = stdout;
        this.configureLogger();
    }

    public void init(boolean stdout) {
        ConfiguratorLoggerFactory.stdout = stdout;
        level = Level.ALL;
        this.configureLogger();
    }

    public void init(Node node) {
        Node loggerConfiguration = DOMUtils.getOneNodeChild(node, "logger");
        if (loggerConfiguration == null) {
            return;
        }
        stdout = DOMUtils.getBooleanParameter(loggerConfiguration, "stdout", false);
        String levelString = DOMUtils.getParameter(loggerConfiguration, "level", "info");
        level = Level.toLevel((String)levelString);
        numberOfGatheredLogFiles = DOMUtils.getIntParameter(loggerConfiguration, "numberOfGatheredLogFiles", 7);
        String rotateLogFolder = DOMUtils.getParameter(loggerConfiguration, "rotateLogPattern", "");
        if (!rotateLogFolder.equals("")) {
            rotateLogPattern = rotateLogFolder;
        }
        logFile = DOMUtils.getParameter(loggerConfiguration, "logFile", "output.log");
        String pattern = DOMUtils.getParameter(loggerConfiguration, "pattern", "");
        if (!pattern.equals("")) {
            loggingPattern = pattern;
        }
        this.configureLogger();
    }

    private void configureLogger() {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        LoggerContext loggerContext = rootLogger.getLoggerContext();
        PatternLayoutEncoder logEncoder = new PatternLayoutEncoder();
        logEncoder.setContext((Context)loggerContext);
        logEncoder.setPattern(loggingPattern);
        logEncoder.start();
        LinkedList<Appender<ILoggingEvent>> appenders = new LinkedList<Appender<ILoggingEvent>>();
        if (stdout) {
            appenders.add(this.getSystemOutLogger(loggerContext, logEncoder));
        } else {
            appenders.add(this.getFileLogger(loggerContext, logEncoder));
        }
        logEncoder = new PatternLayoutEncoder();
        logEncoder.setContext((Context)loggerContext);
        logEncoder.setPattern(loggingPattern);
        logEncoder.start();
        rootLogger.setAdditive(false);
        rootLogger.setLevel(level);
        rootLogger.detachAndStopAllAppenders();
        for (Appender appender : appenders) {
            rootLogger.addAppender(appender);
        }
    }

    private Appender<ILoggingEvent> getSystemOutLogger(LoggerContext loggerContext, PatternLayoutEncoder logEncoder) {
        ConsoleAppender logConsoleAppender = new ConsoleAppender();
        logConsoleAppender.setContext((Context)loggerContext);
        logConsoleAppender.setName("console");
        logConsoleAppender.setEncoder((Encoder)logEncoder);
        logConsoleAppender.start();
        ConsoleAppender appender = logConsoleAppender;
        return appender;
    }

    private Appender<ILoggingEvent> getFileLogger(LoggerContext loggerContext, PatternLayoutEncoder logEncoder) {
        RollingFileAppender logFileAppender = new RollingFileAppender();
        logFileAppender.setContext((Context)loggerContext);
        logFileAppender.setName(logFile);
        logFileAppender.setEncoder((Encoder)logEncoder);
        logFileAppender.setAppend(true);
        logFileAppender.setFile(logFile);
        TimeBasedRollingPolicy logFilePolicy = new TimeBasedRollingPolicy();
        logFilePolicy.setContext((Context)loggerContext);
        logFilePolicy.setParent((FileAppender)logFileAppender);
        logFilePolicy.setFileNamePattern(rotateLogPattern);
        logFilePolicy.setMaxHistory(numberOfGatheredLogFiles);
        logFilePolicy.start();
        logFileAppender.setRollingPolicy((RollingPolicy)logFilePolicy);
        logFileAppender.start();
        RollingFileAppender appender = logFileAppender;
        return appender;
    }

    public static void setRootLogLevel(Level level) {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        ConfiguratorLoggerFactory.level = level;
        rootLogger.setLevel(level);
    }

    public static String getLevel() {
        return ConfiguratorLoggerFactory.level.levelStr;
    }

    public static String getLogFile() {
        return logFile;
    }

    public static String getLoggingPattern() {
        return loggingPattern;
    }

    public static int getNumberOfGatheredLogFiles() {
        return numberOfGatheredLogFiles;
    }

    public static String getRotateLogPattern() {
        return rotateLogPattern;
    }

    public static boolean isStdout() {
        return stdout;
    }
}

