/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils.logger;

import com.browsersoft.config.utils.logger.LoggerEventListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class LoggerStringBuffer<K>
implements List<K> {
    private final List<K> list;
    private int maxSize;
    private final List<LoggerEventListener> eventListeners = new LinkedList<LoggerEventListener>();

    protected void addLoggerEventListener(LoggerEventListener listener) {
        this.eventListeners.add(listener);
    }

    public LoggerStringBuffer(int maxSize) {
        this.list = Collections.synchronizedList(new ArrayList(maxSize));
        this.maxSize = maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        List<K> list = this.list;
        synchronized (list) {
            while (this.size() > maxSize) {
                this.list.remove(0);
            }
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<K> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public synchronized boolean add(K k) {
        if (this.list.size() >= this.maxSize) {
            this.list.remove(0);
        }
        this.list.add(k);
        this.eventListeners.forEach(LoggerEventListener::onEvent);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends K> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void replaceAll(UnaryOperator<K> operator) {
        this.list.replaceAll(operator);
    }

    @Override
    public void sort(Comparator<? super K> c) {
        this.list.sort(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public K get(int index) {
        return this.list.get(index);
    }

    @Override
    public K set(int index, K element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, K element) {
        this.list.add(index, element);
    }

    @Override
    public K remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<K> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<K> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<K> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Spliterator<K> spliterator() {
        return this.list.spliterator();
    }

    @Override
    public boolean removeIf(Predicate<? super K> filter) {
        return this.list.removeIf(filter);
    }

    @Override
    public Stream<K> stream() {
        return this.list.stream();
    }

    @Override
    public Stream<K> parallelStream() {
        return this.list.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super K> action) {
        this.list.forEach(action);
    }

    public String toString() {
        return this.list.toString();
    }
}

