/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils.logger;

import com.browsersoft.config.utils.logger.LoggerEventListener;
import com.browsersoft.config.utils.logger.LoggerStringBuffer;
import com.browsersoft.config.utils.logger.MiddleOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class RedirectConsole {
    private final LoggerStringBuffer<String> strings = new LoggerStringBuffer(1000);
    private final PrintStream sysout = System.out;
    private final PrintStream syserr = System.err;
    private final OutputStream newout = new MiddleOutputStream(this.sysout, this.strings);
    private final OutputStream newerr = new MiddleOutputStream(this.syserr, this.strings);
    private static RedirectConsole instance;

    public void registerListener(LoggerEventListener listener) {
        this.strings.addLoggerEventListener(listener);
    }

    private RedirectConsole() {
    }

    public static RedirectConsole getInstance() {
        if (instance == null) {
            instance = new RedirectConsole();
        }
        return instance;
    }

    public void setMaxNumberOfLines(int maxNumberOfLines) {
        this.strings.setMaxSize(maxNumberOfLines);
    }

    public void boundStreams() {
        System.setOut(new PrintStream(this.newout));
        System.setErr(new PrintStream(this.newerr));
    }

    public void unboundStreams() {
        System.setOut(this.sysout);
        System.setErr(this.syserr);
    }

    public String getBuffer() {
        StringBuilder resultBuilder = new StringBuilder();
        for (String s : this.strings) {
            resultBuilder.append(s);
        }
        return resultBuilder.toString();
    }
}

