/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils.smtp;

import com.browsersoft.config.utils.DOMUtils;
import com.browsersoft.config.utils.Mailer;
import org.w3c.dom.Node;

public class SmtpConfiguration {
    private String smtpHostname;
    private String smtpUsername;
    private String smtpPassword;
    private String port;
    private Mailer.TransportType transport;
    private String from;
    private String replyTo;
    private String bcc;

    public SmtpConfiguration(Node node) {
        if (node != null) {
            this.smtpHostname = DOMUtils.getParameter(node, "hostname");
            this.port = DOMUtils.getParameter(node, "port");
            this.smtpUsername = DOMUtils.getParameter(node, "username");
            this.smtpPassword = DOMUtils.getParameter(node, "password");
            try {
                this.transport = Mailer.TransportType.fromString(DOMUtils.getParameter(node, "transport", ""));
            }
            catch (IllegalArgumentException e) {
                this.transport = Mailer.TransportType.SSL;
            }
            this.from = DOMUtils.getParameter(node, "from");
            this.replyTo = DOMUtils.getParameter(node, "replyTo");
            this.bcc = DOMUtils.getParameter(node, "bcc");
        }
    }

    public Mailer.Settings getMailerSettings() {
        Mailer.Settings settings = new Mailer.Settings();
        settings.setSmtpHostname(this.smtpHostname);
        settings.setSmtpUsername(this.smtpUsername);
        settings.setSmtpPassword(this.smtpPassword);
        settings.setSmtpPort(this.port);
        settings.setSmtpTransportType(this.transport);
        settings.setFrom(this.from);
        settings.setReplyTo(this.replyTo);
        settings.setBcc(this.bcc);
        return settings;
    }
}

