/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate;

import com.browsersoft.config.jgate.GateNodeHandler;
import com.browsersoft.config.jgate.accesslog.AccessLogConfiguration;
import com.browsersoft.config.jgate.classloading.JarsStorageService;
import com.browsersoft.config.jgate.classloading.JarsStorageServiceProxy;
import com.browsersoft.config.jgate.comm.lowlevel.Receiver;
import com.browsersoft.config.jgate.comm.lowlevel.Sender;
import com.browsersoft.config.jgate.comm.middlelevel.request.GateRoutePath;
import com.browsersoft.config.jgate.configuration.GateNodeConfiguration;
import com.browsersoft.config.jgate.external.Logger;
import com.browsersoft.config.jgate.external.RuleResolver;
import com.browsersoft.config.jgate.node.GateNodeClientPart;
import com.browsersoft.config.jgate.node.GateNodeServerPart;
import com.browsersoft.config.jgate.proxy.GateNodeProxy;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class GateNode {
    private GateNodeServerPart serverPart;
    private GateNodeClientPart clientPart;
    protected GateNodeConfiguration configuration;
    protected GateNodeHandler handler;
    private String id;

    public GateNode() {
        this(UUID.randomUUID().toString());
        this.configuration = new GateNodeConfiguration();
        this.init();
    }

    public GateNode(String id) {
        this.id = id;
        this.configuration = new GateNodeConfiguration();
        this.init();
    }

    public GateNode(String id, GateNodeConfiguration configuration) {
        this.id = id;
        this.configuration = configuration;
        this.init();
    }

    public GateNode(GateNodeConfiguration configuration) {
        this.configuration = configuration;
        this.init();
    }

    public Map<String, Object> getRegisteredServices() {
        return this.serverPart.getRegisteredServices();
    }

    public void closeAllReceivers() {
        this.serverPart.closeAllReceivers();
    }

    public void setRuleResolverToService(String serviceName, RuleResolver ruleResolver) throws Exception {
        this.serverPart.setRuleResolverToService(serviceName, ruleResolver);
    }

    public void setLoggerToService(String serviceName, Logger logger) throws Exception {
        this.serverPart.setLoggerToService(serviceName, logger);
    }

    public JarsStorageService createJarsStorage() {
        JarsStorageService storageService = new JarsStorageService();
        this.registerService("JarsStorageService", storageService, JarsStorageServiceProxy.class.getName());
        return storageService;
    }

    private void init() {
        this.clientPart = new GateNodeClientPart(this.configuration, this.id);
        this.serverPart = new GateNodeServerPart(this.configuration, this.id, this.clientPart);
        this.clientPart.setGateNodeServerPart(this.serverPart);
    }

    public GateNodeProxy getProxyByGateNodeId(String gateId) {
        return this.clientPart.getProxyByGateNodeId(gateId);
    }

    public GateNodeHandler getHandler() {
        return this.handler;
    }

    public void setHandler(GateNodeHandler handler) {
        this.handler = handler;
        this.serverPart.setGateNodeHandler(handler);
        this.clientPart.setGateNodeHandler(handler);
    }

    public void setLogger(Logger logger) {
        this.serverPart.setLogger(logger);
    }

    public GateNodeProxy connect(Sender sender) throws Exception {
        return this.clientPart.connect(sender, "", "");
    }

    public GateNodeProxy connect(GateRoutePath routePath) throws Exception {
        return this.clientPart.connect(routePath);
    }

    public GateNodeProxy connect(Sender sender, String user, String password) throws Exception {
        return this.clientPart.connect(sender, user, password);
    }

    public void setPublicSender(Sender sender) {
        this.clientPart.setPublicSender(sender);
    }

    public void disconnect(GateNodeProxy proxy) throws Exception {
        this.clientPart.disconnect(proxy);
    }

    public void addReceiver(Receiver receiver) {
        this.serverPart.addReceiver(receiver);
    }

    public void startAccessLog(String instanceName) {
        this.serverPart.startAccessLog(instanceName);
    }

    public void shutdownAccessLogger(String instanceName) {
        this.serverPart.shutDownAccessLogger(instanceName);
    }

    public void configureAccessLog(String instanceName, AccessLogConfiguration logConfiguration) throws IOException {
        this.serverPart.configureAccessLog(instanceName, logConfiguration);
    }

    public void registerService(Object service, String proxyClass) {
        this.registerService("", service, null, proxyClass);
    }

    public void unregisterAllServices() {
        this.serverPart.unregisterAllServices();
    }

    public void registerService(String instanceName, Object service, String proxyClass) {
        this.registerService(instanceName, service, null, proxyClass);
    }

    public void unregisterService(String instanceName) {
        this.serverPart.unregisterService(instanceName);
    }

    public void registerService(String instanceName, Object service, RuleResolver ruleResolver, String proxyClass) {
        this.serverPart.registerService(instanceName, service, ruleResolver, proxyClass);
    }

    public void registerService(String instanceName, Object service, RuleResolver ruleResolver, String proxyClass, ClassLoader classLoader) {
        this.serverPart.registerService(instanceName, service, ruleResolver, proxyClass, classLoader);
    }

    public void registerService(String instanceName, Object service, String proxyClass, ClassLoader classLoader) {
        this.serverPart.registerService(instanceName, service, null, proxyClass, classLoader);
    }

    public List<GateNodeProxy> getClientConnections() throws Exception {
        return this.serverPart.getClientConnections();
    }

    public List<GateNodeProxy> getServerConnections() {
        return this.clientPart.getServerConnections();
    }

    public GateNodeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GateNodeConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

