/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.accesslog;

import com.browsersoft.config.utils.DOMUtils;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class AccessLogConfiguration {
    private String logFileName = "access_log";
    private String logRotateFolder = "access_logs/";
    private Duration logRotateDuration = Duration.ofDays(1L);
    private int maxRetentionLogs = 30;
    private static final Logger log = Logger.getLogger(AccessLogConfiguration.class.getName());

    public AccessLogConfiguration(Node node) {
        if (node == null) {
            return;
        }
        this.maxRetentionLogs = DOMUtils.getIntParameter((Node)node, (String)"maxRetentionLogs", (int)this.maxRetentionLogs);
        this.logFileName = DOMUtils.getParameter((Node)node, (String)"accessLogFile", (String)this.logFileName);
        this.logRotateFolder = DOMUtils.getParameter((Node)node, (String)"logRotateFolder", (String)this.logRotateFolder);
        try {
            String durationString = DOMUtils.getParameter((Node)node, (String)"logRotateDuration", (String)"");
            if (durationString.length() > 0) {
                this.logRotateDuration = Duration.parse(durationString);
                if (this.logRotateDuration.isNegative()) {
                    this.logRotateDuration = this.logRotateDuration.abs();
                }
            }
        }
        catch (DateTimeParseException e) {
            log.log(Level.SEVERE, "Could not parse access log rotate duration, using default one", e);
        }
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public String getLogRotateFolder() {
        return this.logRotateFolder;
    }

    public Duration getLogRotateDuration() {
        return this.logRotateDuration;
    }

    public int getMaxRetentionLogs() {
        return this.maxRetentionLogs;
    }
}

