/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.accesslog;

import com.browsersoft.config.jgate.accesslog.AccessLogConfiguration;
import com.browsersoft.config.jgate.accesslog.LogRecord;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AccessLogger
extends Thread {
    private final ConcurrentLinkedQueue<LogRecord> notLoggedLogRecords;
    private final AtomicBoolean isConfigured = new AtomicBoolean(false);
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final AtomicBoolean isAvailable = new AtomicBoolean(false);
    private AccessLogConfiguration configuration;
    private File logFile;
    private BufferedWriter writer;
    private Instant nextLogRotation;
    private static final String PATTERN_FORMAT = "yyyyMMdd-hh:mm";
    private static final Logger logger = Logger.getLogger(AccessLogger.class.getName());

    public AccessLogger() {
        logger.setLevel(Level.INFO);
        this.notLoggedLogRecords = new ConcurrentLinkedQueue();
        this.setDaemon(true);
    }

    public boolean configure(AccessLogConfiguration configuration) throws IOException {
        if (this.isConfigured.get()) {
            logger.warning("Could not reconfigure access log service");
            return false;
        }
        this.configuration = configuration;
        this.createLogFile();
        this.initWriterAndNextRotation();
        this.isAvailable.set(true);
        this.isConfigured.set(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(LogRecord logRecord) throws Exception {
        if (this.isConfigured.get() && this.isRunning.get()) {
            ConcurrentLinkedQueue<LogRecord> concurrentLinkedQueue = this.notLoggedLogRecords;
            synchronized (concurrentLinkedQueue) {
                if (this.notLoggedLogRecords.size() > 5000) {
                    this.notLoggedLogRecords.poll();
                }
                this.notLoggedLogRecords.add(logRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isConfigured.get()) {
            logger.warning("Could not start access log service because it is not configured");
            return;
        }
        logger.info("Starting access log service");
        this.isRunning.set(true);
        while (this.isRunning.get()) {
            try {
                if (Instant.now().isAfter(this.nextLogRotation)) {
                    this.rotateLogFile();
                }
                while (!this.notLoggedLogRecords.isEmpty() && this.isAvailable.get() && this.isRunning.get()) {
                    LogRecord logRecord;
                    ConcurrentLinkedQueue<LogRecord> concurrentLinkedQueue = this.notLoggedLogRecords;
                    synchronized (concurrentLinkedQueue) {
                        logRecord = this.notLoggedLogRecords.poll();
                    }
                    if (logRecord == null) continue;
                    this.writer.write(logRecord.toString());
                    this.writer.newLine();
                }
                if (this.isAvailable.get()) {
                    this.writer.flush();
                }
                if (!this.isRunning.get()) continue;
                try {
                    AccessLogger.sleep(10L);
                }
                catch (InterruptedException logRecord) {
                }
            }
            catch (IOException e) {
                this.isAvailable.set(false);
                logger.log(Level.SEVERE, "Error while logging to access log", e);
                try {
                    Duration d = Duration.between(Instant.now(), this.nextLogRotation.plus(10L, ChronoUnit.SECONDS));
                    AccessLogger.sleep(d.toMillis());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public String toString() {
        return "AccessLoggingService";
    }

    private void rotateLogFile() {
        File moveFolder = new File(this.configuration.getLogRotateFolder());
        if (!moveFolder.exists() && !moveFolder.mkdirs()) {
            logger.log(Level.SEVERE, "Could not create access log rotation folder");
            return;
        }
        try {
            this.isAvailable.set(false);
            this.writer.close();
            String formattedInstant = this.getFormattedTimeForFileName();
            File rotateFile = new File(moveFolder.getPath() + "/" + this.configuration.getLogFileName() + "-" + formattedInstant);
            if (!this.logFile.renameTo(rotateFile)) {
                throw new IOException("Could not move rotated access log");
            }
            if (!this.logFile.createNewFile()) {
                throw new IOException("Could not create new access log file");
            }
            this.initWriterAndNextRotation();
            this.isAvailable.set(true);
            this.deleteOldFiles(moveFolder);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error with access log rotation", e);
        }
    }

    private void initWriterAndNextRotation() throws IOException {
        this.writer = new BufferedWriter(new FileWriter(this.logFile));
        this.nextLogRotation = Instant.now().plus(this.configuration.getLogRotateDuration());
        this.nextLogRotation = this.nextLogRotation.truncatedTo(ChronoUnit.MINUTES);
    }

    private void deleteOldFiles(File moveFolder) {
        try {
            String logFileName = this.configuration.getLogFileName().toLowerCase();
            File[] accessLogFiles = moveFolder.listFiles((dir, name) -> name.toLowerCase().startsWith(logFileName));
            if (accessLogFiles == null) {
                throw new IOException("Could not open access log rotate folder");
            }
            if (accessLogFiles.length > this.configuration.getMaxRetentionLogs()) {
                logger.info("Deleting old access logs");
                Arrays.sort(accessLogFiles, Comparator.comparing(File::getName));
                for (int i = 0; i < accessLogFiles.length - this.configuration.getMaxRetentionLogs(); ++i) {
                    if (accessLogFiles[i].delete()) {
                        logger.info("Deleted access log " + accessLogFiles[i].getName());
                        continue;
                    }
                    logger.warning("Could not delete access log " + accessLogFiles[i].getName());
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not delete old access log files", e);
        }
    }

    private void createLogFile() throws IOException {
        this.logFile = new File(this.configuration.getLogFileName());
        if (!this.logFile.exists() && !this.logFile.createNewFile()) {
            throw new IOException("Could not create access log file");
        }
    }

    private String getFormattedTimeForFileName() {
        Instant rotateTime = Instant.now().minus(this.configuration.getLogRotateDuration()).truncatedTo(ChronoUnit.MINUTES);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(PATTERN_FORMAT).withZone(ZoneId.systemDefault());
        return formatter.format(rotateTime);
    }

    public void shutdown() {
        this.isAvailable.set(false);
        this.isRunning.set(false);
        this.interrupt();
        boolean logged = false;
        while (this.notLoggedLogRecords.size() > 0) {
            LogRecord record = this.notLoggedLogRecords.poll();
            try {
                this.writer.write(record.toString());
                this.writer.newLine();
            }
            catch (IOException e) {
                if (logged) continue;
                logger.log(Level.WARNING, "Could not log ", e);
                logged = true;
            }
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

