/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.classloading;

import com.browsersoft.config.jgate.classloading.JarsStorageServiceProxy;
import com.browsersoft.config.jgate.proxy.GateNodeProxy;
import com.browsersoft.config.jgate.proxy.handlers.SyncProgressMethodHandler;
import com.browsersoft.config.jgate.util.GateUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.prefs.Preferences;

public class JarsRepositoryOnClient {
    private Preferences preferences;
    private String tempDir;
    private ClassLoader globalClassLoader;

    public JarsRepositoryOnClient(Class h) {
        this.preferences = Preferences.userNodeForPackage(h);
    }

    public File[] constructJars(String serviceName, GateNodeProxy gateNodeProxy, SyncProgressMethodHandler updateHandler) throws Exception {
        if (this.globalClassLoader != null) {
            JarsStorageServiceProxy serviceProxy = (JarsStorageServiceProxy)gateNodeProxy.getProxy("JarsStorageService", false);
            String[] ids = serviceProxy.getJarsIdsForService("_GLOBAL_");
            return this.getFilesFromIds(ids, serviceProxy, serviceName, updateHandler);
        }
        JarsStorageServiceProxy serviceProxy = (JarsStorageServiceProxy)gateNodeProxy.getProxy("JarsStorageService", false);
        String[] ids = serviceProxy.getJarsIdsForService("_GLOBAL_");
        if (ids != null) {
            return this.getFilesFromIds(ids, serviceProxy, "_GLOBAL_", updateHandler);
        }
        ids = serviceProxy.getJarsIdsForService(serviceName);
        if (ids == null) {
            return null;
        }
        return this.getFilesFromIds(ids, serviceProxy, serviceName, updateHandler);
    }

    public ClassLoader constructClassLoader(String serviceName, GateNodeProxy gateNodeProxy, SyncProgressMethodHandler updateHandler) throws Exception {
        if (this.globalClassLoader != null) {
            return this.globalClassLoader;
        }
        JarsStorageServiceProxy serviceProxy = (JarsStorageServiceProxy)gateNodeProxy.getProxy("JarsStorageService", false);
        String[] ids = serviceProxy.getJarsIdsForService("_GLOBAL_");
        if (ids != null) {
            this.globalClassLoader = this.getClassLoaderFromIds(ids, serviceProxy, "_GLOBAL_", updateHandler);
            return this.globalClassLoader;
        }
        ids = serviceProxy.getJarsIdsForService(serviceName);
        if (ids == null) {
            return null;
        }
        return this.getClassLoaderFromIds(ids, serviceProxy, serviceName, updateHandler);
    }

    private ClassLoader getClassLoaderFromIds(String[] ids, JarsStorageServiceProxy serviceProxy, String serviceName, SyncProgressMethodHandler updateHandler) throws Exception {
        URL[] urls = new URL[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            urls[i] = this.getFile(ids[i], serviceProxy, serviceName, updateHandler).toURI().toURL();
        }
        return new URLClassLoader(urls, this.getClass().getClassLoader());
    }

    private File[] getFilesFromIds(String[] ids, JarsStorageServiceProxy serviceProxy, String serviceName, SyncProgressMethodHandler updateHandler) throws Exception {
        File[] urls = new File[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            urls[i] = this.getFile(ids[i], serviceProxy, serviceName, updateHandler);
        }
        return urls;
    }

    public File getFile(String id, JarsStorageServiceProxy proxy, String serviceName, SyncProgressMethodHandler handler) throws Exception {
        File fileToOutput;
        if (this.tempDir == null) {
            this.tempDir = this.getTempDir();
        }
        if ((fileToOutput = new File(this.tempDir + "/" + id + ".jar")).exists()) {
            return fileToOutput;
        }
        InputStream inputStream = proxy.getJar(id, serviceName);
        FileOutputStream outputStream = new FileOutputStream(fileToOutput);
        GateUtils.inputStreamToOutputStreamWithHandler(inputStream, (OutputStream)outputStream, handler, "Downloading " + id + ".jar", (long)inputStream.available(), 30000);
        inputStream.close();
        ((OutputStream)outputStream).close();
        return fileToOutput;
    }

    public void setTempDir(String tempDir) throws IOException {
        if (tempDir.equals("")) {
            tempDir = JarsRepositoryOnClient.getTempDirectory().getAbsolutePath();
        }
        this.preferences.put("TempDir", tempDir);
    }

    public String getTempDir() throws IOException, ClassNotFoundException {
        File tempFile;
        String tempDir = this.preferences.get("TempDir", null);
        if (tempDir == null) {
            File temp = JarsRepositoryOnClient.getTempDirectory();
            this.preferences.put("TempDir", temp.getAbsolutePath());
        }
        if (!(tempFile = new File((tempDir = this.preferences.get("TempDir", "")) + "/")).exists() && !tempFile.mkdir()) {
            throw new IOException();
        }
        return tempFile.getAbsolutePath();
    }

    private static File getTempDirectory() throws IOException {
        File tempFile = File.createTempFile("JGate", "", null);
        tempFile.delete();
        tempFile = new File(tempFile.getAbsolutePath() + "/");
        if (!tempFile.exists() && !tempFile.mkdir()) {
            throw new IOException();
        }
        return tempFile;
    }

    public ClassLoader getGlobalClassLoader() {
        return this.globalClassLoader;
    }

    public void setGlobalClassLoader(ClassLoader globalClassLoader) {
        this.globalClassLoader = globalClassLoader;
    }
}

