/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.comm.middlelevel;

import com.browsersoft.config.jgate.comm.middlelevel.GateReceiver;
import com.browsersoft.config.jgate.comm.middlelevel.GateReceiverHandler;
import com.browsersoft.config.jgate.comm.middlelevel.LongCallMethodThread;
import com.browsersoft.config.jgate.comm.middlelevel.base.ClientInfo;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateClientInfo;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateRequestWithId;
import com.browsersoft.config.jgate.comm.middlelevel.base.MethodCalling;
import com.browsersoft.config.jgate.comm.middlelevel.base.ProgressState;
import com.browsersoft.config.jgate.comm.middlelevel.request.BeginCallMethodGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.CancelProgressGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.ClientCallingsGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.ClientLoginGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.ClientLogoutGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.CloseStreamGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.EndCallMethodGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.GateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.ProgressGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.ReadFromInputStreamGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.ReadResponseBytesGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.SendingBytesGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.SimpleCallMethodGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.WriteToOutputStreamGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.response.BytesGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.ClientCallingsGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.GateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.IdGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.OKGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.ProgressGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.ProxyInfosGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.ReturnedObjectAsByteArray;
import com.browsersoft.config.jgate.comm.middlelevel.response.ReturnedObjectGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.SizedInputStreamGateResponse;
import com.browsersoft.config.jgate.configuration.GateNodeConfiguration;
import com.browsersoft.config.jgate.exceptions.GateIOException;
import com.browsersoft.config.jgate.exceptions.GateRouteException;
import com.browsersoft.config.jgate.node.GateNodeProxyServant;
import com.browsersoft.config.jgate.proxy.ServiceCallMethodHandler;
import com.browsersoft.config.jgate.proxy.ServiceProxyInfo;
import com.browsersoft.config.jgate.repositories.calling.CallingRepository;
import com.browsersoft.config.jgate.repositories.progress.ProgressRepository;
import com.browsersoft.config.jgate.repositories.streams.InputStreamRepositoryItem;
import com.browsersoft.config.jgate.repositories.streams.OutputStreamRepositoryItem;
import com.browsersoft.config.jgate.repositories.streams.StreamInfoFromServer;
import com.browsersoft.config.jgate.repositories.streams.StreamRepositoryItem;
import com.browsersoft.config.jgate.repositories.streams.StreamsRepository;
import com.browsersoft.config.utils.streams.SizedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GateReceiverImpl
implements GateReceiver {
    private GateReceiverHandler handler;
    private CallingRepository callingRepository;
    private ProgressRepository progressRepository = new ProgressRepository();
    private StreamsRepository streamRepository;
    private GateNodeConfiguration configuration;
    private String gateNodeId;
    private static final Logger logger = LoggerFactory.getLogger(GateReceiverImpl.class);

    public GateReceiverImpl(GateNodeConfiguration configuration, String gateNodeId) {
        this.gateNodeId = gateNodeId;
        this.configuration = configuration;
        this.streamRepository = new StreamsRepository(configuration);
        this.callingRepository = new CallingRepository(configuration);
    }

    @Override
    public GateResponse incomingRequest(GateClientInfo clientInfo, GateRequest request) throws Exception {
        String id;
        if (request.getPath() != null && (id = request.getPath().removeLast()) != null) {
            GateNodeProxyServant servant = this.handler.getServantForNode(id);
            if (servant == null) {
                throw new GateRouteException("It is not possible to contact node \"" + id + "\" on node \"" + this.gateNodeId + "\"");
            }
            return servant.sendRequest(request);
        }
        try {
            switch (request.getTypeOfRequest()) {
                case BEGIN_CALL_METHOD: {
                    return this.doBeginCallMethod(clientInfo, (BeginCallMethodGateRequest)request);
                }
                case SENDING_REQUEST_BYTES: {
                    return this.doSendingRequestBytes(clientInfo, (SendingBytesGateRequest)request);
                }
                case END_CALL_METHOD: {
                    return this.doEndCallMethod(clientInfo, (EndCallMethodGateRequest)request);
                }
                case READ_RESPONSE_BYTES: {
                    return this.doReadResposeBytes(clientInfo, (ReadResponseBytesGateRequest)request);
                }
                case SIMPLE_CALL_METHOD: {
                    return this.doSimpleCallMethod(clientInfo, (SimpleCallMethodGateRequest)request);
                }
                case PROGRESS: {
                    return this.doProgressGateRequest(clientInfo, (ProgressGateRequest)request);
                }
                case GET_PROXIES: {
                    return this.doGetProxiesGateRequest(clientInfo);
                }
                case READ_FROM_INPUT_STREAM: {
                    return this.doReadFromInputStream(clientInfo, (ReadFromInputStreamGateRequest)request);
                }
                case WRITE_TO_OUTPUT_STREM: {
                    return this.doWriteToOutputStream(clientInfo, (WriteToOutputStreamGateRequest)request);
                }
                case CLOSE_STREAM: {
                    return this.doCloseStream(clientInfo, (CloseStreamGateRequest)request);
                }
                case CANCEL_PROGRESS: {
                    return this.doCancelProgressGateRequest(clientInfo, (CancelProgressGateRequest)request);
                }
                case CHECK_CLIENT_CALLINGS: {
                    return this.doClientCalling(clientInfo, (ClientCallingsGateRequest)request);
                }
                case CLIENT_LOGIN: {
                    return this.doClientLogin(clientInfo, (ClientLoginGateRequest)request);
                }
                case CLIENT_LOGOUT: {
                    return this.doClientLogout(clientInfo, (ClientLogoutGateRequest)request);
                }
                case PING: {
                    return new OKGateResponse();
                }
            }
            return null;
        }
        catch (GateIOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GateIOException(e);
        }
    }

    private GateResponse doClientCalling(GateClientInfo gateClientInfo, ClientCallingsGateRequest clientCallingsGateRequest) throws Exception {
        String clientId = clientCallingsGateRequest.getClientId();
        ClientCallingsGateResponse response = new ClientCallingsGateResponse();
        List<GateRequestWithId> requestWithIds = this.handler.getClientsRequests(clientId, clientCallingsGateRequest.getResponses());
        if (requestWithIds == null) {
            response.setDisconnected(true);
        } else {
            response.setRequests(requestWithIds);
        }
        return response;
    }

    private GateResponse doClientLogout(GateClientInfo gateClientInfo, ClientLogoutGateRequest clientLogoutGateRequest) {
        this.handler.clientDisconnect(clientLogoutGateRequest.getId());
        return new OKGateResponse();
    }

    private GateResponse doClientLogin(GateClientInfo gateClientInfo, ClientLoginGateRequest request) throws Exception {
        ClientInfo clientInfo = new ClientInfo();
        clientInfo.setSender(request.getSender());
        clientInfo.setId(request.getGateNodeId());
        if (request.isRealClient()) {
            this.handler.clientConnect(clientInfo);
        }
        IdGateResponse response = new IdGateResponse();
        response.setId(this.gateNodeId);
        return response;
    }

    private GateResponse doCancelProgressGateRequest(GateClientInfo gateClientInfo, CancelProgressGateRequest request) {
        ProgressState progressState = this.progressRepository.getState(request.getId());
        progressState.setState(ProgressState.ProgressStateType.CANCELED_BY_USER);
        ProgressGateResponse response = new ProgressGateResponse();
        response.setProgressState(this.progressRepository.cloneState(request.getId()));
        return response;
    }

    private GateResponse doCloseStream(GateClientInfo gateClientInfo, CloseStreamGateRequest request) throws Exception {
        try {
            StreamRepositoryItem item = this.streamRepository.getItem(request.getId());
            item.close();
            this.streamRepository.removeItem(request.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new OKGateResponse();
    }

    private GateResponse doWriteToOutputStream(GateClientInfo gateClientInfo, WriteToOutputStreamGateRequest request) throws Exception {
        OutputStreamRepositoryItem item = (OutputStreamRepositoryItem)this.streamRepository.getItem(request.getId());
        item.writeToStream(request.getBytes());
        return new OKGateResponse();
    }

    private GateResponse doReadFromInputStream(GateClientInfo gateClientInfo, ReadFromInputStreamGateRequest request) throws Exception {
        InputStreamRepositoryItem item = (InputStreamRepositoryItem)this.streamRepository.getItem(request.getId());
        byte[] bytes = item.readFromStream();
        if (bytes.length == 0) {
            this.streamRepository.removeItem(request.getId());
        }
        BytesGateResponse bytesGateResponse = new BytesGateResponse();
        bytesGateResponse.setBytes(bytes);
        bytesGateResponse.setMoreBytes(bytes.length != 0);
        return bytesGateResponse;
    }

    private GateResponse doGetProxiesGateRequest(GateClientInfo gateClientInfo) {
        List<ServiceProxyInfo> infoListService = this.handler.getProxyInfos();
        ProxyInfosGateResponse response = new ProxyInfosGateResponse();
        response.setProxyInfos(infoListService);
        return response;
    }

    private ProgressGateResponse doProgressGateRequest(GateClientInfo gateClientInfo, ProgressGateRequest request) throws Exception {
        ProgressGateResponse response = new ProgressGateResponse();
        response.setProgressState(this.progressRepository.cloneState(request.getId()));
        return response;
    }

    private IdGateResponse doBeginCallMethod(GateClientInfo gateClientInfo, BeginCallMethodGateRequest request) throws Exception {
        String id = this.callingRepository.newCallingRequest();
        IdGateResponse response = new IdGateResponse();
        response.setId(id);
        return response;
    }

    private OKGateResponse doSendingRequestBytes(GateClientInfo gateClientInfo, SendingBytesGateRequest request) throws Exception {
        this.callingRepository.writeBytesToCallingRequest(request.getId(), request.getBytes());
        return new OKGateResponse();
    }

    private GateResponse doEndCallMethod(GateClientInfo gateClientInfo, EndCallMethodGateRequest request) throws Exception {
        MethodCalling methodCalling = this.callingRepository.finishCallingRequest(request.getId());
        return this.doCall(gateClientInfo, methodCalling, request.isUseStreamForResponse(), request.isHandleProgress());
    }

    private GateResponse doReadResposeBytes(GateClientInfo gateClientInfo, ReadResponseBytesGateRequest request) throws Exception {
        return this.callingRepository.readBytesFromResponse(request);
    }

    private GateResponse doSimpleCallMethod(GateClientInfo gateClientInfo, SimpleCallMethodGateRequest request) throws Exception {
        return this.doCall(gateClientInfo, request.getMethodParams(), request.isUseStreamForResponse(), request.isHandleProgress());
    }

    private GateResponse doCall(GateClientInfo gateClientInfo, MethodCalling methodCalling, boolean useStreamForResponse, boolean handleProgress) throws Exception {
        logger.debug("Calling " + methodCalling.getMethod());
        if (handleProgress) {
            LongCallMethodThread longCallMethodThread = new LongCallMethodThread();
            longCallMethodThread.setGateNodeReceiver(this);
            longCallMethodThread.setGateClientInfo(gateClientInfo);
            longCallMethodThread.setGateMethodParams(methodCalling);
            longCallMethodThread.setProgressRepository(this.progressRepository);
            longCallMethodThread.setCallingRepository(this.callingRepository);
            String id = this.progressRepository.newState();
            this.progressRepository.getState(id).setUseStreamForResponse(useStreamForResponse);
            longCallMethodThread.setIdOfProgress(id);
            Thread t = new Thread(longCallMethodThread);
            t.start();
            IdGateResponse idGateResponse = new IdGateResponse();
            idGateResponse.setId(id);
            return idGateResponse;
        }
        Object returned = this.callMethod(gateClientInfo, methodCalling, null);
        if (useStreamForResponse) {
            return this.callingRepository.newCallingResponse(returned);
        }
        if (returned instanceof SizedInputStream) {
            return new SizedInputStreamGateResponse((SizedInputStream)returned);
        }
        ReturnedObjectGateResponse response = new ReturnedObjectGateResponse();
        response.setObject(new ReturnedObjectAsByteArray(returned));
        return response;
    }

    public Object callMethod(GateClientInfo gateClientInfo, MethodCalling calling, ServiceCallMethodHandler serviceCallMethodHandler) throws Exception {
        Object object = this.handler.callMethod(gateClientInfo, calling, serviceCallMethodHandler);
        if (object instanceof InputStream && !(object instanceof SizedInputStream)) {
            InputStream inputStream = (InputStream)object;
            String id = this.streamRepository.newInputStream(inputStream);
            StreamInfoFromServer infoFromServer = new StreamInfoFromServer();
            infoFromServer.setId(id);
            infoFromServer.setSize(inputStream.available());
            infoFromServer.setType(StreamInfoFromServer.TypeOfStream.INPUT_STREAM);
            return infoFromServer;
        }
        if (object instanceof OutputStream) {
            OutputStream outputStream = (OutputStream)object;
            String id = this.streamRepository.newOutputStream(outputStream);
            StreamInfoFromServer infoFromServer = new StreamInfoFromServer();
            infoFromServer.setId(id);
            infoFromServer.setType(StreamInfoFromServer.TypeOfStream.OUTPUT_STREAM);
            return infoFromServer;
        }
        return object;
    }

    @Override
    public void setHandler(GateReceiverHandler handler) {
        this.handler = handler;
    }

    @Override
    public GateReceiverHandler getHandler() {
        return this.handler;
    }
}

