/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.comm.middlelevel;

import com.browsersoft.config.jgate.comm.middlelevel.GateReceiverImpl;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateClientInfo;
import com.browsersoft.config.jgate.comm.middlelevel.base.MethodCalling;
import com.browsersoft.config.jgate.comm.middlelevel.base.ProgressState;
import com.browsersoft.config.jgate.comm.middlelevel.response.IdAndSizeGateResponse;
import com.browsersoft.config.jgate.proxy.ServiceCallMethodHandler;
import com.browsersoft.config.jgate.repositories.calling.CallingRepository;
import com.browsersoft.config.jgate.repositories.progress.ProgressRepository;

public class LongCallMethodThread
implements Runnable,
ServiceCallMethodHandler {
    private MethodCalling methodCalling;
    private ProgressRepository progressRepository;
    private String idOfProgress;
    private GateReceiverImpl gateNodeReceiver;
    private CallingRepository callingRepository;
    private GateClientInfo gateClientInfo;

    @Override
    public void run() {
        try {
            Object object = this.gateNodeReceiver.callMethod(this.gateClientInfo, this.methodCalling, this);
            if (this.progressRepository.getState(this.idOfProgress).isUseStreamForResponse()) {
                IdAndSizeGateResponse idGateResponse = this.callingRepository.newCallingResponse(object);
                this.progressRepository.finishWithReturnedStream(this.idOfProgress, idGateResponse.getId(), idGateResponse.getSizeOfResponse());
            } else {
                this.progressRepository.finishWithReturnedObject(this.idOfProgress, object);
            }
        }
        catch (Exception e) {
            this.progressRepository.finishWithError(this.idOfProgress, e);
        }
    }

    public MethodCalling getGateMethodParams() {
        return this.methodCalling;
    }

    public void setGateMethodParams(MethodCalling methodCalling) {
        this.methodCalling = methodCalling;
    }

    public ProgressRepository getProgressRepository() {
        return this.progressRepository;
    }

    public void setProgressRepository(ProgressRepository progressRepository) {
        this.progressRepository = progressRepository;
    }

    public String getIdOfProgress() {
        return this.idOfProgress;
    }

    public void setIdOfProgress(String idOfProgress) {
        this.idOfProgress = idOfProgress;
    }

    @Override
    public boolean callingMethodInProgress(int percent, String message) {
        if (this.progressRepository.getState(this.idOfProgress).getState() == ProgressState.ProgressStateType.CANCELED_BY_USER) {
            return false;
        }
        this.progressRepository.addRunning(this.idOfProgress, percent, message);
        return true;
    }

    public CallingRepository getCallingRepository() {
        return this.callingRepository;
    }

    public void setCallingRepository(CallingRepository callingRepository) {
        this.callingRepository = callingRepository;
    }

    public GateReceiverImpl getGateNodeReceiver() {
        return this.gateNodeReceiver;
    }

    public void setGateNodeReceiver(GateReceiverImpl gateNodeReceiver) {
        this.gateNodeReceiver = gateNodeReceiver;
    }

    public GateClientInfo getGateClientInfo() {
        return this.gateClientInfo;
    }

    public void setGateClientInfo(GateClientInfo gateClientInfo) {
        this.gateClientInfo = gateClientInfo;
    }
}

