/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.comm.middlelevel.base;

import com.browsersoft.config.jgate.comm.middlelevel.base.ProgressStateItem;
import com.browsersoft.config.jgate.exceptions.GateCommException;
import com.browsersoft.config.jgate.proxy.handlers.SyncMethodHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ProgressState
implements Serializable {
    private List<ProgressStateItem> items = new ArrayList<ProgressStateItem>();
    private ProgressStateType state = ProgressStateType.RUNNING;
    private Object object;
    private boolean useStreamForResponse;
    private int sizeOfResponse;
    private String idOfResponseStream;

    public ProgressState cloneState() {
        ProgressState progressState = new ProgressState();
        progressState.setIdOfResponseStream(this.idOfResponseStream);
        progressState.setObject(this.object);
        progressState.setSizeOfResponse(this.sizeOfResponse);
        progressState.setState(this.state);
        progressState.setUseStreamForResponse(this.useStreamForResponse);
        for (ProgressStateItem item : this.items) {
            progressState.getItems().add(item);
        }
        return progressState;
    }

    public boolean generateEvents(SyncMethodHandler handler) throws GateCommException {
        for (ProgressStateItem item : this.items) {
            boolean ret = handler.callingMethodInProgress(SyncMethodHandler.ProgressType.PROCESSING_METHOD, item.getPercent(), item.getMessage());
            if (ret) continue;
            return false;
        }
        this.items.clear();
        return true;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setState(ProgressStateType state) {
        this.state = state;
    }

    public ProgressStateType getState() {
        return this.state;
    }

    public boolean isUseStreamForResponse() {
        return this.useStreamForResponse;
    }

    public void setUseStreamForResponse(boolean useStreamForResponse) {
        this.useStreamForResponse = useStreamForResponse;
    }

    public int getSizeOfResponse() {
        return this.sizeOfResponse;
    }

    public void setSizeOfResponse(int sizeOfResponse) {
        this.sizeOfResponse = sizeOfResponse;
    }

    public String getIdOfResponseStream() {
        return this.idOfResponseStream;
    }

    public void setIdOfResponseStream(String idOfResponseStream) {
        this.idOfResponseStream = idOfResponseStream;
    }

    public boolean isItFinish() {
        return this.state != ProgressStateType.RUNNING;
    }

    public void setItems(List<ProgressStateItem> items) {
        this.items = items;
    }

    public List<ProgressStateItem> getItems() {
        return this.items;
    }

    public static enum ProgressStateType {
        RUNNING,
        FINISH_WITH_RETURNED_OBJECT,
        FINISH_WITH_ERROR,
        FINISH_WITH_RETURNED_STREAM,
        CANCELED_BY_USER;

    }
}

