/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.node;

import com.browsersoft.config.jgate.comm.middlelevel.base.GateClientInfo;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateRequestWithId;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateResponseWithId;
import com.browsersoft.config.jgate.comm.middlelevel.response.GateResponse;
import com.browsersoft.config.jgate.configuration.GateNodeConfiguration;
import com.browsersoft.config.jgate.node.CheckCallingThreadHandler;
import com.browsersoft.config.jgate.node.GateNodeServerPart;
import com.browsersoft.config.jgate.proxy.GateNodeProxy;
import java.util.ArrayList;
import java.util.List;

public class CheckCallingThread
extends Thread {
    private GateNodeServerPart gateNodeServerPart;
    private GateNodeProxy gateNodeProxy;
    private boolean shouldStop;
    private CheckCallingThreadHandler handler;
    private GateNodeConfiguration configuration;

    @Override
    public void run() {
        List<GateResponseWithId> responses = new ArrayList<GateResponseWithId>();
        while (!this.shouldStop) {
            try {
                List<GateRequestWithId> requests = this.gateNodeProxy.checkClientCalling(responses, null);
                if (requests == null) {
                    this.handler.mustReconnect(this.gateNodeProxy);
                    return;
                }
                if (requests.size() > 0) {
                    responses = this.doRequests(requests);
                    this.sleepShort();
                    continue;
                }
                this.sleepLong();
            }
            catch (Exception e) {
                this.handler.error(e);
            }
        }
    }

    private void sleepLong() {
        try {
            int sleepTime = this.configuration.getInt("CLIENT_CHECK_SLEEP_LONG", 3000);
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void sleepShort() {
        try {
            int sleepTime = this.configuration.getInt("CLIENT_CHECK_SLEEP_SHORT", 0);
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private List<GateResponseWithId> doRequests(List<GateRequestWithId> requests) throws Exception {
        ArrayList<GateResponseWithId> responses = new ArrayList<GateResponseWithId>();
        for (GateRequestWithId requestWithId : requests) {
            GateResponse response = this.gateNodeServerPart.incomingRequest(new GateClientInfo(), requestWithId.getRequest());
            GateResponseWithId responseWithId = new GateResponseWithId();
            responseWithId.setId(requestWithId.getId());
            responseWithId.setGateResponse(response);
            responses.add(responseWithId);
        }
        return responses;
    }

    public void stopThread() {
        this.shouldStop = true;
    }

    public GateNodeServerPart getGateNodeServerPart() {
        return this.gateNodeServerPart;
    }

    public void setGateNodeServerPart(GateNodeServerPart gateNodeServerPart) {
        this.gateNodeServerPart = gateNodeServerPart;
    }

    public GateNodeProxy getGateNodeProxy() {
        return this.gateNodeProxy;
    }

    public void setGateNodeProxy(GateNodeProxy gateNodeProxy) {
        this.gateNodeProxy = gateNodeProxy;
    }

    public CheckCallingThreadHandler getHandler() {
        return this.handler;
    }

    public void setHandler(CheckCallingThreadHandler handler) {
        this.handler = handler;
    }

    public GateNodeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GateNodeConfiguration configuration) {
        this.configuration = configuration;
    }
}

