/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.node;

import com.browsersoft.config.jgate.accesslog.AccessLogConfiguration;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateClientInfo;
import com.browsersoft.config.jgate.comm.middlelevel.base.MethodCalling;
import com.browsersoft.config.jgate.exceptions.GateMethodInvocationException;
import com.browsersoft.config.jgate.external.Logger;
import com.browsersoft.config.jgate.external.RuleResolver;
import com.browsersoft.config.jgate.node.ServiceWrapper;
import com.browsersoft.config.jgate.proxy.ServiceCallMethodHandler;
import com.browsersoft.config.jgate.proxy.ServiceProxyInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Gate {
    private Logger logger;
    private Map<String, ServiceWrapper> instances = new HashMap<String, ServiceWrapper>();

    public void configureAccessLog(String instanceName, AccessLogConfiguration configuration) throws IOException {
        this.instances.get(instanceName).configureAccessLog(configuration);
    }

    public void startAccessLog(String instanceName) {
        this.instances.get(instanceName).startAccessLog();
    }

    public void shutdownAccessLogger(String instanceName) {
        this.instances.get(instanceName).shutdownAccessLog();
    }

    public void registerService(String instanceName, Object instance, RuleResolver ruleResolver, String proxyClass, ClassLoader classLoader) {
        if (this.instances.containsKey(instanceName)) {
            this.instances.remove(instanceName);
        }
        ServiceWrapper wrapper = new ServiceWrapper(instance);
        wrapper.setInstanceName(instanceName);
        wrapper.setLogger(this.logger);
        wrapper.setRuleResolver(ruleResolver);
        wrapper.setProxyClass(proxyClass);
        wrapper.setClassLoader(classLoader);
        this.instances.put(instanceName, wrapper);
    }

    public void setRuleResolverToService(String serviceName, RuleResolver ruleResolver) throws Exception {
        if (!this.instances.containsKey(serviceName)) {
            throw new Exception("Service \"" + serviceName + "\" does not exist");
        }
        ServiceWrapper serviceWrapper = this.instances.get(serviceName);
        serviceWrapper.setRuleResolver(ruleResolver);
    }

    public void setLoggerToService(String serviceName, Logger logger) throws Exception {
        if (!this.instances.containsKey(serviceName)) {
            throw new Exception("Service \"" + serviceName + "\" does not exist");
        }
        ServiceWrapper serviceWrapper = this.instances.get(serviceName);
        serviceWrapper.setLogger(logger);
    }

    public Map<String, Object> getRegisteredServices() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set<String> keys = this.instances.keySet();
        for (String key : keys) {
            map.put(key, this.instances.get(key).getService());
        }
        return map;
    }

    public List<ServiceProxyInfo> getProxyInfos() {
        ArrayList<ServiceProxyInfo> list = new ArrayList<ServiceProxyInfo>();
        Set<String> keys = this.instances.keySet();
        for (String key : keys) {
            ServiceWrapper wrapper = this.instances.get(key);
            ServiceProxyInfo serviceProxyInfo = new ServiceProxyInfo();
            serviceProxyInfo.setObjectClassName(wrapper.getService().getClass().getName());
            serviceProxyInfo.setProxyClassName(wrapper.getProxyClass());
            serviceProxyInfo.setInstanceName(key);
            list.add(serviceProxyInfo);
        }
        return list;
    }

    public Object callMethod(GateClientInfo gateClientInfo, MethodCalling methodCalling, ServiceCallMethodHandler handler) throws Exception {
        if (!this.instances.containsKey(methodCalling.getInstanceName())) {
            throw new GateMethodInvocationException("No registered service with name \"" + methodCalling.getInstanceName() + "\"");
        }
        return this.instances.get(methodCalling.getInstanceName()).callMethod(gateClientInfo, methodCalling, handler);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
        Set<String> keys = this.instances.keySet();
        for (String key : keys) {
            ServiceWrapper wrapper = this.instances.get(key);
            wrapper.setLogger(logger);
        }
    }

    public void unregisterAllServices() {
        this.instances.clear();
    }

    public void unregisterService(String instanceName) {
        this.instances.remove(instanceName);
    }
}

