/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.node;

import com.browsersoft.config.jgate.GateNodeHandler;
import com.browsersoft.config.jgate.comm.lowlevel.Sender;
import com.browsersoft.config.jgate.comm.middlelevel.request.GateRoutePath;
import com.browsersoft.config.jgate.configuration.GateNodeConfiguration;
import com.browsersoft.config.jgate.exceptions.GateRouteException;
import com.browsersoft.config.jgate.node.CheckCallingThread;
import com.browsersoft.config.jgate.node.CheckCallingThreadHandler;
import com.browsersoft.config.jgate.node.DirectAccessGateNodeProxyServant;
import com.browsersoft.config.jgate.node.GateNodeProxyServant;
import com.browsersoft.config.jgate.node.GateNodeServerPart;
import com.browsersoft.config.jgate.proxy.DirectGateNodeProxy;
import com.browsersoft.config.jgate.proxy.GateNodeProxy;
import com.browsersoft.config.jgate.proxy.RouteGateNodeProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GateNodeClientPart
implements CheckCallingThreadHandler {
    private GateNodeServerPart gateNodeServerPart;
    private List<GateNodeProxy> nodeProxyList = new ArrayList<GateNodeProxy>();
    private Sender publicSender;
    private Map<String, CheckCallingThread> callingThreadHashMap = new HashMap<String, CheckCallingThread>();
    private GateNodeConfiguration configuration;
    private GateNodeHandler gateNodeHandler;
    private String gateNodeId;
    private static final Logger logger = LoggerFactory.getLogger((String)GateNodeClientPart.class.getName());

    public GateNodeClientPart(GateNodeConfiguration configuration, String gateNodeId) {
        this.configuration = configuration;
        this.gateNodeId = gateNodeId;
    }

    public GateNodeProxy connect(GateRoutePath gateRoutePath) throws Exception {
        if (gateRoutePath == null) {
            throw new GateRouteException("invalid route path");
        }
        if (gateRoutePath.size() == 0) {
            throw new GateRouteException("invalid route path");
        }
        String id = gateRoutePath.removeLast();
        DirectGateNodeProxy gateNodeProxy = this.getProxyByGateNodeId(id);
        if (gateNodeProxy == null) {
            throw new GateRouteException("It is not possible to contact node \"" + id + "\" on node \"" + this.gateNodeId + "\"");
        }
        if (gateRoutePath.size() == 0) {
            return gateNodeProxy;
        }
        return new RouteGateNodeProxy(gateNodeProxy, gateRoutePath);
    }

    public GateNodeProxy connect(Sender sender, String user, String password) throws Exception {
        GateNodeProxy gateNodeProxyA = this.haveISuchProxy(sender);
        if (gateNodeProxyA != null) {
            return gateNodeProxyA;
        }
        DirectGateNodeProxy gateNodeProxy = new DirectGateNodeProxy(new DirectAccessGateNodeProxyServant(sender), this.configuration, this.gateNodeId, sender.getId());
        gateNodeProxy.setUser(user);
        gateNodeProxy.setPassword(password);
        this.nodeProxyList.add(gateNodeProxy);
        gateNodeProxy.clientLogin(this.publicSender, null);
        if (this.publicSender == null && this.configuration.getInt("DISABLE_CLIENT_CALLING", 0) == 0) {
            CheckCallingThread checkCallingThread = new CheckCallingThread();
            if (this.configuration.getInt("NO_DAEMON_CLIENT_CALLING", 0) == 0) {
                checkCallingThread.setDaemon(true);
            }
            checkCallingThread.setName("Gate: check calling thread");
            checkCallingThread.setConfiguration(this.configuration);
            checkCallingThread.setGateNodeProxy(gateNodeProxy);
            checkCallingThread.setGateNodeServerPart(this.gateNodeServerPart);
            checkCallingThread.setHandler(this);
            this.callingThreadHashMap.put(gateNodeProxy.getClientId(), checkCallingThread);
            checkCallingThread.start();
        }
        return gateNodeProxy;
    }

    public GateNodeProxyServant getServantForNode(String id) {
        for (GateNodeProxy gateNodeProxy : this.nodeProxyList) {
            if (!gateNodeProxy.getGateNodeId().equals(id)) continue;
            return gateNodeProxy.getServant();
        }
        return null;
    }

    public DirectGateNodeProxy getProxyByGateNodeId(String gateId) {
        for (GateNodeProxy gateNodeProxy : this.nodeProxyList) {
            if (!gateNodeProxy.getGateNodeId().equals(gateId)) continue;
            return (DirectGateNodeProxy)gateNodeProxy;
        }
        return this.gateNodeServerPart.getProxyByGateNodeId(gateId);
    }

    public GateNodeProxy haveISuchProxy(Sender sender) {
        for (GateNodeProxy gateNodeProxy : this.nodeProxyList) {
            if (!gateNodeProxy.getSenderId().equals(sender.getId())) continue;
            return gateNodeProxy;
        }
        return null;
    }

    public void disconnect(GateNodeProxy proxy) throws Exception {
        if (this.callingThreadHashMap.containsKey(proxy.getClientId())) {
            this.callingThreadHashMap.get(proxy.getClientId()).stopThread();
            this.callingThreadHashMap.remove(proxy.getClientId());
        }
        try {
            proxy.clientLogout(null);
        }
        catch (Exception e) {
            logger.warn("Gate: cannot logout.");
        }
        this.nodeProxyList.remove(proxy);
    }

    public List<GateNodeProxy> getServerConnections() {
        return this.nodeProxyList;
    }

    public GateNodeServerPart getGateNodeServerPart() {
        return this.gateNodeServerPart;
    }

    public void setGateNodeServerPart(GateNodeServerPart gateNodeServerPart) {
        this.gateNodeServerPart = gateNodeServerPart;
    }

    public Sender getPublicSender() {
        return this.publicSender;
    }

    public void setPublicSender(Sender publicSender) {
        this.publicSender = publicSender;
    }

    @Override
    public void error(Exception e) {
        logger.warn("", (Throwable)e);
    }

    @Override
    public void mustReconnect(GateNodeProxy gateNodeProxy) {
        if (this.gateNodeHandler != null) {
            this.gateNodeHandler.disconnectFromServer(gateNodeProxy);
        }
    }

    public GateNodeHandler getGateNodeHandler() {
        return this.gateNodeHandler;
    }

    public void setGateNodeHandler(GateNodeHandler gateNodeHandler) {
        this.gateNodeHandler = gateNodeHandler;
    }

    public GateNodeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GateNodeConfiguration configuration) {
        this.configuration = configuration;
    }
}

