/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.node;

import com.browsersoft.config.jgate.GateNodeHandler;
import com.browsersoft.config.jgate.accesslog.AccessLogConfiguration;
import com.browsersoft.config.jgate.comm.lowlevel.Receiver;
import com.browsersoft.config.jgate.comm.lowlevel.ReceiverHandler;
import com.browsersoft.config.jgate.comm.lowlevel.SocketReceiverThread;
import com.browsersoft.config.jgate.comm.lowlevel.SocketSender;
import com.browsersoft.config.jgate.comm.middlelevel.GateReceiver;
import com.browsersoft.config.jgate.comm.middlelevel.GateReceiverHandler;
import com.browsersoft.config.jgate.comm.middlelevel.GateReceiverImpl;
import com.browsersoft.config.jgate.comm.middlelevel.base.ClientInfo;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateClientInfo;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateRequestWithId;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateResponseWithId;
import com.browsersoft.config.jgate.comm.middlelevel.base.MethodCalling;
import com.browsersoft.config.jgate.comm.middlelevel.request.GateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.SimpleCallMethodGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.response.ExceptionGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.GateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.SizedInputStreamGateResponse;
import com.browsersoft.config.jgate.configuration.GateNodeConfiguration;
import com.browsersoft.config.jgate.exceptions.GateCommException;
import com.browsersoft.config.jgate.external.RuleResolver;
import com.browsersoft.config.jgate.node.DirectAccessGateNodeProxyServant;
import com.browsersoft.config.jgate.node.Gate;
import com.browsersoft.config.jgate.node.GateNodeClientPart;
import com.browsersoft.config.jgate.node.GateNodeProxyServant;
import com.browsersoft.config.jgate.node.VirtualCallingGateNodeProxyServant;
import com.browsersoft.config.jgate.proxy.DirectGateNodeProxy;
import com.browsersoft.config.jgate.proxy.GateNodeProxy;
import com.browsersoft.config.jgate.proxy.ServiceCallMethodHandler;
import com.browsersoft.config.jgate.proxy.ServiceProxyInfo;
import com.browsersoft.config.jgate.repositories.clients.ClientsRepository;
import com.browsersoft.config.jgate.repositories.clients.ClientsRepositoryHandler;
import com.browsersoft.config.jgate.repositories.clients.ClientsRepositoryItem;
import com.browsersoft.config.jgate.repositories.gaterequests.GateRequestRepository;
import com.browsersoft.config.jgate.util.GateUtils;
import com.browsersoft.config.utils.streams.SizedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GateNodeServerPart
implements ReceiverHandler,
GateReceiverHandler,
ClientsRepositoryHandler {
    private GateReceiver gateReceiver;
    private Gate gate = new Gate();
    private ClientsRepository clientsRepository;
    private GateRequestRepository requestRepository = new GateRequestRepository();
    private GateNodeConfiguration configuration;
    private GateNodeHandler gateNodeHandler;
    private String gateNodeId;
    private GateNodeClientPart gateNodeClientPart;
    private List<Receiver> receivers = new ArrayList<Receiver>();
    private static final Logger logger = LoggerFactory.getLogger(GateNodeServerPart.class);

    public GateNodeServerPart(GateNodeConfiguration configuration, String gateNodeId, GateNodeClientPart gateNodeClientPart) {
        this.gateNodeId = gateNodeId;
        this.configuration = configuration;
        this.gateReceiver = new GateReceiverImpl(configuration, gateNodeId);
        this.clientsRepository = new ClientsRepository(configuration);
        this.gateReceiver.setHandler(this);
        this.clientsRepository.setHandler(this);
        this.gateNodeClientPart = gateNodeClientPart;
    }

    public Map<String, Object> getRegisteredServices() {
        return this.gate.getRegisteredServices();
    }

    public void addReceiver(Receiver receiver) {
        receiver.setHandler(this);
        this.receivers.add(receiver);
    }

    public void configureAccessLog(String instanceName, AccessLogConfiguration accessLogConfiguration) throws IOException {
        this.gate.configureAccessLog(instanceName, accessLogConfiguration);
    }

    public void shutDownAccessLogger(String instanceName) {
        this.gate.shutdownAccessLogger(instanceName);
    }

    public void startAccessLog(String instanceName) {
        this.gate.startAccessLog(instanceName);
    }

    public void closeAllReceivers() {
        for (Receiver receiver : this.receivers) {
            try {
                receiver.stopReceiving();
            }
            catch (Exception e) {
                logger.warn("", (Throwable)e);
            }
        }
        this.receivers.clear();
    }

    public GateResponse incomingRequest(GateClientInfo clientInfo, GateRequest request) throws Exception {
        long start = System.currentTimeMillis();
        GateResponse gateResponse = this.gateReceiver.incomingRequest(clientInfo, request);
        logger.debug(System.currentTimeMillis() - start + " mS");
        return gateResponse;
    }

    @Override
    public GateNodeProxyServant getServantForNode(String id) {
        GateNodeProxyServant servant = this.gateNodeClientPart.getServantForNode(id);
        if (servant != null) {
            return servant;
        }
        ClientsRepositoryItem item = this.clientsRepository.getItem(id);
        if (item == null) {
            return null;
        }
        return item.getServant();
    }

    public DirectGateNodeProxy getProxyByGateNodeId(String gateId) {
        return null;
    }

    @Override
    public byte[] incomingBytesForInputStream(GateClientInfo gateClientInfo, InputStream callInputStream, OutputStream outputStream) throws Exception {
        return this.handleStreamRequest(gateClientInfo, callInputStream, outputStream);
    }

    @Override
    public byte[] incomingBytesForOutputStream(GateClientInfo gateClientInfo, InputStream callInputStream, InputStream inputStream) throws Exception {
        return this.handleStreamRequest(gateClientInfo, callInputStream, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] handleStreamRequest(GateClientInfo gateClientInfo, InputStream inputStream, Object stream) throws Exception {
        Object object = GateUtils.deserializeInputStreamToObject(inputStream);
        if (!(object instanceof GateRequest)) {
            throw new GateCommException("Object is not an instance of " + GateRequest.class.getName());
        }
        GateRequest gateRequest = (GateRequest)object;
        if (!(gateRequest instanceof SimpleCallMethodGateRequest)) {
            throw new GateCommException("Object is not an instance of " + SimpleCallMethodGateRequest.class.getName());
        }
        MethodCalling methodCalling = ((SimpleCallMethodGateRequest)gateRequest).getMethodParams();
        if (stream instanceof InputStream) {
            InputStream inStream = (InputStream)stream;
            long length = SocketReceiverThread.readLength(inStream);
            stream = new SizedInputStream(inStream, length);
        }
        methodCalling.setStream(stream);
        GateResponse response = this.incomingRequest(gateClientInfo, gateRequest);
        byte[] bytes = new byte[]{};
        if (stream instanceof OutputStream && response instanceof SizedInputStreamGateResponse) {
            SizedInputStream sizedInputStream = ((SizedInputStreamGateResponse)response).getInputStream();
            OutputStream outputStream = (OutputStream)stream;
            try {
                byte[] sizeBytes = SocketSender.longToBytes(sizedInputStream.getSize());
                outputStream.write(sizeBytes);
                GateUtils.inputStreamToOutputStreamWithHandler((InputStream)sizedInputStream, outputStream, null, sizedInputStream.getSize(), 1024);
            }
            finally {
                try {
                    sizedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        bytes = GateUtils.serializeObjectToByteArray(response);
        return bytes;
    }

    @Override
    public GateResponse incomingBytes(GateClientInfo clientInfo, InputStream inputStream) throws Exception {
        GateResponse response;
        try {
            Object object = GateUtils.deserializeInputStreamToObject(inputStream);
            if (!(object instanceof GateRequest)) {
                throw new GateCommException("Object is not an instance of " + GateRequest.class.getName());
            }
            response = this.incomingRequest(clientInfo, (GateRequest)object);
        }
        catch (Throwable e) {
            ExceptionGateResponse exceptionGateResponse = new ExceptionGateResponse();
            exceptionGateResponse.setException(e);
            response = exceptionGateResponse;
        }
        return response;
    }

    public void unregisterService(String instanceName) {
        this.gate.unregisterService(instanceName);
    }

    public void registerService(String instanceName, Object service, RuleResolver ruleResolver, String proxyClass) {
        this.gate.registerService(instanceName, service, ruleResolver, proxyClass, service.getClass().getClassLoader());
    }

    public void registerService(String instanceName, Object service, RuleResolver ruleResolver, String proxyClass, ClassLoader classLoader) {
        this.gate.registerService(instanceName, service, ruleResolver, proxyClass, classLoader);
    }

    public void setRuleResolverToService(String serviceName, RuleResolver ruleResolver) throws Exception {
        this.gate.setRuleResolverToService(serviceName, ruleResolver);
    }

    public void setLoggerToService(String serviceName, com.browsersoft.config.jgate.external.Logger logger) throws Exception {
        this.gate.setLoggerToService(serviceName, logger);
    }

    @Override
    public Object callMethod(GateClientInfo gateClientInfo, MethodCalling methodCalling, ServiceCallMethodHandler handler) throws Exception {
        return this.gate.callMethod(gateClientInfo, methodCalling, handler);
    }

    @Override
    public List<ServiceProxyInfo> getProxyInfos() {
        return this.gate.getProxyInfos();
    }

    @Override
    public String clientConnect(ClientInfo clientInfo) throws Exception {
        String newId = clientInfo.getId();
        if (clientInfo.getSender() != null) {
            this.clientsRepository.addItem(newId, clientInfo.getId(), new DirectAccessGateNodeProxyServant(clientInfo.getSender()), false);
        } else {
            VirtualCallingGateNodeProxyServant servant = new VirtualCallingGateNodeProxyServant(this.configuration);
            servant.setClientId(newId);
            servant.setRequestRepository(this.requestRepository);
            this.clientsRepository.addItem(newId, clientInfo.getId(), servant, true);
        }
        return newId;
    }

    @Override
    public List<GateRequestWithId> getClientsRequests(String id, List<GateResponseWithId> responses) throws Exception {
        this.clientsRepository.updateLastAccess(id);
        this.requestRepository.responsesReceived(id, responses);
        return this.requestRepository.getRequestsForClient(id);
    }

    public List<GateNodeProxy> getClientConnections() throws Exception {
        return this.clientsRepository.toNodeProxies(this.gateNodeId);
    }

    @Override
    public void clientDisconnect(String id) {
        this.clientsRepository.removeItem(id);
    }

    public void unregisterAllServices() {
        this.gate.unregisterAllServices();
    }

    public void setLogger(com.browsersoft.config.jgate.external.Logger logger) {
        this.gate.setLogger(logger);
    }

    @Override
    public void clientConnected(String id) {
        if (this.gateNodeHandler != null) {
            this.gateNodeHandler.clientConnected(id);
        }
    }

    @Override
    public void clientDisconnected(String id) {
        if (this.gateNodeHandler != null) {
            this.gateNodeHandler.clientDisconnected(id);
        }
    }

    public GateNodeHandler getGateNodeHandler() {
        return this.gateNodeHandler;
    }

    public void setGateNodeHandler(GateNodeHandler gateNodeHandler) {
        this.gateNodeHandler = gateNodeHandler;
    }

    public String getGateNodeId() {
        return this.gateNodeId;
    }

    public void setGateNodeId(String gateNodeId) {
        this.gateNodeId = gateNodeId;
    }
}

