/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.node;

import com.browsersoft.config.jgate.accesslog.AccessLogConfiguration;
import com.browsersoft.config.jgate.accesslog.AccessLogger;
import com.browsersoft.config.jgate.accesslog.LogRecord;
import com.browsersoft.config.jgate.annotations.GateMethod;
import com.browsersoft.config.jgate.annotations.HandleProgress;
import com.browsersoft.config.jgate.annotations.LogIt;
import com.browsersoft.config.jgate.annotations.UserName;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateClientInfo;
import com.browsersoft.config.jgate.comm.middlelevel.base.MethodCalling;
import com.browsersoft.config.jgate.exceptions.GateIOException;
import com.browsersoft.config.jgate.exceptions.GateMethodInvocationException;
import com.browsersoft.config.jgate.exceptions.GateUserErrorException;
import com.browsersoft.config.jgate.external.RuleResolver;
import com.browsersoft.config.jgate.proxy.ServiceCallMethodHandler;
import com.browsersoft.config.jgate.util.GateUtils;
import com.browsersoft.config.utils.ExceptionUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceWrapper {
    private Object service;
    private Map<String, Method> methods = new HashMap<String, Method>();
    private com.browsersoft.config.jgate.external.Logger logger;
    private RuleResolver ruleResolver;
    private String proxyClass;
    private String instanceName;
    private ClassLoader classLoader;
    private final AccessLogger accessLogger = new AccessLogger();
    private static final Logger log = LoggerFactory.getLogger(ServiceWrapper.class);

    public ServiceWrapper(Object object) throws IllegalArgumentException {
        Method[] methodsArray;
        this.service = object;
        for (Method method : methodsArray = object.getClass().getMethods()) {
            GateMethod gateMethodAnotation = method.getAnnotation(GateMethod.class);
            if (gateMethodAnotation == null) continue;
            String methodName = method.getName();
            if (this.methods.containsKey(methodName)) {
                throw new IllegalArgumentException("Server object contains methods with the same name: \"" + methodName + "\".");
            }
            this.methods.put(method.getName(), method);
        }
    }

    public void configureAccessLog(AccessLogConfiguration configuration) throws IOException {
        this.accessLogger.configure(configuration);
    }

    public void startAccessLog() {
        this.accessLogger.start();
    }

    public void shutdownAccessLog() {
        this.accessLogger.shutdown();
    }

    public Object callMethod(GateClientInfo gateClientInfo, MethodCalling methodCalling, ServiceCallMethodHandler handler) throws Exception {
        String method = methodCalling.getMethod();
        Object[] params = methodCalling.getParams(this.classLoader);
        String user = methodCalling.getUser();
        String password = methodCalling.getPassword();
        if (this.methods.containsKey(method)) {
            Method methodObject = this.methods.get(method);
            LogIt logItAnnotation = methodObject.getAnnotation(LogIt.class);
            try {
                UserName userName;
                if (this.ruleResolver != null && !this.ruleResolver.checkMethod(gateClientInfo, methodObject, params, user, password)) {
                    String message = "Acces denied for method \"" + method + "\"";
                    if (logItAnnotation != null) {
                        this.logIt(1, null, message, methodObject, params, user, password);
                    }
                    throw new GateUserErrorException(message);
                }
                HandleProgress handleProgress = methodObject.getAnnotation(HandleProgress.class);
                if (handleProgress != null) {
                    params = GateUtils.extendParams(params, handler);
                }
                if ((userName = methodObject.getAnnotation(UserName.class)) != null) {
                    params = GateUtils.extendParams(params, user);
                }
                Object returned = methodObject.invoke(this.service, params);
                this.accessLogger.log(new LogRecord(gateClientInfo.getRemoteHost(), Instant.now(), user, methodObject.getName()));
                if (logItAnnotation != null) {
                    this.logIt(0, null, "OK", methodObject, params, user, password);
                }
                return returned;
            }
            catch (Exception e) {
                String stackTrace;
                Exception userException;
                Throwable localEx = e;
                if (e instanceof InvocationTargetException) {
                    localEx = e.getCause();
                }
                UUID uuid = UUID.randomUUID();
                String message = "Error calling method \"" + method + "\" UUID: " + uuid;
                log.warn(message, (Throwable)e);
                if (logItAnnotation != null) {
                    this.logIt(4, e, message, methodObject, params, user, password);
                }
                if ((userException = ExceptionUtils.getCauseWithSpecifiedType((Throwable)localEx, GateUserErrorException.class)) != null) {
                    throw new GateIOException(userException.getMessage());
                }
                if (!gateClientInfo.isAdmin()) {
                    throw new GateIOException("Internal server error", uuid);
                }
                GateIOException gateIOException = new GateIOException(localEx.getClass().getName() + " " + localEx.getMessage(), uuid);
                try (StringWriter sw = new StringWriter();
                     PrintWriter pw = new PrintWriter(sw);){
                    localEx.printStackTrace(pw);
                    stackTrace = sw.toString();
                }
                gateIOException.setOriginalStack(stackTrace);
                throw gateIOException;
            }
        }
        String message = "Wrapped object doesn't have method with the specified name: \"" + method + "\"";
        this.logIt(2, null, message, null, params, user, password);
        throw new GateMethodInvocationException(message);
    }

    public void logIt(int type, Exception e, String message, Method method, Object[] params, String user, String password) {
        if (this.logger != null) {
            this.logger.logMethod(type, message, e, this.instanceName, this.service, method, params, user);
        }
    }

    public RuleResolver getRuleResolver() {
        return this.ruleResolver;
    }

    public void setRuleResolver(RuleResolver ruleResolver) {
        this.ruleResolver = ruleResolver;
    }

    public com.browsersoft.config.jgate.external.Logger getLogger() {
        return this.logger;
    }

    public void setLogger(com.browsersoft.config.jgate.external.Logger logger) {
        this.logger = logger;
    }

    public Object getService() {
        return this.service;
    }

    public void setService(Object object) {
        this.service = object;
    }

    public String getProxyClass() {
        return this.proxyClass;
    }

    public void setProxyClass(String proxyClass) {
        this.proxyClass = proxyClass;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

