/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.proxy;

import com.browsersoft.config.jgate.classloading.JarsRepositoryOnClient;
import com.browsersoft.config.jgate.comm.lowlevel.StreamsPair;
import com.browsersoft.config.jgate.comm.middlelevel.GateSenderHandler;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateRequestWithId;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateResponseWithId;
import com.browsersoft.config.jgate.comm.middlelevel.base.MethodCalling;
import com.browsersoft.config.jgate.comm.middlelevel.base.ProgressSwitchers;
import com.browsersoft.config.jgate.comm.middlelevel.request.GateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.GateRoutePath;
import com.browsersoft.config.jgate.comm.middlelevel.response.GateResponse;
import com.browsersoft.config.jgate.exceptions.GateCommException;
import com.browsersoft.config.jgate.node.GateNodeProxyServant;
import com.browsersoft.config.jgate.proxy.DirectGateNodeProxy;
import com.browsersoft.config.jgate.proxy.GateNodeProxy;
import com.browsersoft.config.jgate.proxy.ServiceProxy;
import com.browsersoft.config.jgate.proxy.ServiceProxyInfo;
import com.browsersoft.config.jgate.proxy.handlers.AsyncHandler;
import com.browsersoft.config.jgate.proxy.handlers.SyncMethodHandler;
import com.browsersoft.config.jgate.proxy.handlers.SyncProgressMethodHandler;
import com.browsersoft.config.utils.streams.SizedInputStream;
import java.util.ArrayList;
import java.util.List;

public class RouteGateNodeProxy
implements GateNodeProxy,
GateSenderHandler {
    private DirectGateNodeProxy directGateNodeProxy;
    private GateRoutePath gateRoutePath;
    private List<ServiceProxyInfo> serviceProxyInfos;
    private JarsRepositoryOnClient jarsRepositoryOnClient;

    public RouteGateNodeProxy(DirectGateNodeProxy directGateNodeProxy, GateRoutePath gateRoutePath) throws Exception {
        this.directGateNodeProxy = directGateNodeProxy;
        this.gateRoutePath = gateRoutePath;
        this.jarsRepositoryOnClient = new JarsRepositoryOnClient(this.getClass());
        this.serviceProxyInfos = directGateNodeProxy.getGateSender().getProxyInfos(gateRoutePath);
    }

    @Override
    public List<ServiceProxy> getAllProxies(boolean downloadJars) throws Exception {
        return this.getAllProxies(downloadJars, null);
    }

    @Override
    public List<ServiceProxy> getAllProxies(boolean downloadJars, SyncProgressMethodHandler updateHandler) throws Exception {
        ArrayList<ServiceProxy> proxies = new ArrayList<ServiceProxy>();
        for (ServiceProxyInfo info : this.serviceProxyInfos) {
            proxies.add(this.constructProxy(info, downloadJars, updateHandler));
        }
        return proxies;
    }

    @Override
    public ServiceProxy getProxy(String name, boolean downloadJars, SyncProgressMethodHandler updateHandler) throws Exception {
        for (ServiceProxyInfo info : this.serviceProxyInfos) {
            if (!info.getInstanceName().equals(name)) continue;
            ServiceProxy serviceProxy = this.constructProxy(info, downloadJars, updateHandler);
            return serviceProxy;
        }
        throw new Exception("No service with name " + name);
    }

    @Override
    public void ping() throws Exception {
        this.directGateNodeProxy.ping(this.gateRoutePath);
    }

    private ServiceProxy constructProxy(ServiceProxyInfo infoService, boolean downloadJars, SyncProgressMethodHandler updateHandler) throws Exception {
        ClassLoader classLoader = null;
        Object ob = downloadJars ? ((classLoader = this.jarsRepositoryOnClient.constructClassLoader(infoService.getInstanceName(), this, updateHandler)) != null ? classLoader.loadClass(infoService.getProxyClassName()).newInstance() : Class.forName(infoService.getProxyClassName()).newInstance()) : Class.forName(infoService.getProxyClassName()).newInstance();
        if (!(ob instanceof ServiceProxy)) {
            throw new GateCommException("Class \"" + infoService.getProxyClassName() + "\" is not a Proxy object");
        }
        ServiceProxy proxy = (ServiceProxy)ob;
        proxy.setHandler(this);
        proxy.setServiceClassLoader(classLoader);
        proxy.setNameOfInstance(infoService.getInstanceName());
        return proxy;
    }

    @Override
    public ServiceProxy getProxy(String name, boolean downloadJars) throws Exception {
        return this.getProxy(name, downloadJars, null);
    }

    @Override
    public ServiceProxy getProxy() throws Exception {
        return this.getProxy("", false);
    }

    @Override
    public ServiceProxy getProxy(boolean downloadJars) throws Exception {
        return this.getProxy("", downloadJars);
    }

    @Override
    public String getClientId() {
        return this.directGateNodeProxy.getClientId();
    }

    @Override
    public String getGateNodeId() {
        return this.directGateNodeProxy.getGateNodeId();
    }

    @Override
    public GateNodeProxyServant getServant() {
        return this.directGateNodeProxy.getServant();
    }

    @Override
    public String getSenderId() {
        return this.directGateNodeProxy.getSenderId();
    }

    @Override
    public void clientLogout(GateRoutePath gateRoutePath) throws Exception {
        this.directGateNodeProxy.clientLogout(gateRoutePath);
    }

    @Override
    public List<GateRequestWithId> checkClientCalling(List<GateResponseWithId> responses, GateRoutePath gateRoutePath) throws Exception {
        return null;
    }

    @Override
    public Object callMethod(MethodCalling methodCalling, Object[] extraParams, ProgressSwitchers progressSwitchers, SyncMethodHandler handler, ClassLoader classLoader, GateRoutePath g) throws Exception {
        return this.directGateNodeProxy.callMethod(methodCalling, extraParams, progressSwitchers, handler, classLoader, this.gateRoutePath);
    }

    @Override
    public String callMethodAsync(MethodCalling methodCalling, Object[] extraParams, ProgressSwitchers progressSwitchers, AsyncHandler handler, ClassLoader classLoader, GateRoutePath g) {
        return this.directGateNodeProxy.callMethodAsync(methodCalling, extraParams, progressSwitchers, handler, classLoader, this.gateRoutePath);
    }

    public void ping(GateRoutePath gateRoutePath) throws Exception {
        this.directGateNodeProxy.ping(gateRoutePath);
    }

    @Override
    public GateResponse sendRequest(GateRequest request) throws Exception {
        return this.directGateNodeProxy.sendRequest(request);
    }

    public GateRoutePath getRoutePath() {
        return this.gateRoutePath;
    }

    @Override
    public SizedInputStream sendInputStreamRequest(GateRequest request) throws Exception {
        return null;
    }

    @Override
    public StreamsPair sendOutputStreamRequest(GateRequest request) throws Exception {
        return null;
    }
}

