/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.repositories.calling;

import com.browsersoft.config.jgate.comm.middlelevel.base.MethodCalling;
import com.browsersoft.config.jgate.comm.middlelevel.request.ReadResponseBytesGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.response.BytesGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.IdAndSizeGateResponse;
import com.browsersoft.config.jgate.configuration.GateNodeConfiguration;
import com.browsersoft.config.jgate.exceptions.GateCommException;
import com.browsersoft.config.jgate.repositories.calling.Calling;
import com.browsersoft.config.jgate.repositories.calling.CallingRequest;
import com.browsersoft.config.jgate.repositories.calling.CallingResponse;
import com.browsersoft.config.jgate.util.GateUtils;
import java.io.IOException;
import java.util.HashMap;

public class CallingRepository {
    private HashMap<String, Calling> map = new HashMap();
    private GateNodeConfiguration configuration;

    public CallingRepository(GateNodeConfiguration configuration) {
        this.configuration = configuration;
    }

    public IdAndSizeGateResponse newCallingResponse(Object object) throws Exception {
        String id = GateUtils.generateUUID();
        CallingResponse item = new CallingResponse(GateUtils.serializeObjectToByteArray(object));
        this.map.put(id, item);
        IdAndSizeGateResponse response = new IdAndSizeGateResponse();
        response.setId(id);
        response.setSizeOfResponse(item.getRemainingSize());
        return response;
    }

    public BytesGateResponse readBytesFromResponse(ReadResponseBytesGateRequest request) throws Exception {
        CallingResponse callingCacheResponse = this.checkResponseId(request.getId());
        int bufferSize = this.configuration.getInt("STREAM_PARAMS_BUFFER_SIZE", 4096);
        byte[] bytes = callingCacheResponse.read(new byte[bufferSize]);
        BytesGateResponse bytesGateResponse = new BytesGateResponse();
        bytesGateResponse.setBytes(bytes);
        bytesGateResponse.setMoreBytes(callingCacheResponse.getRemainingSize() != 0);
        return bytesGateResponse;
    }

    public String newCallingRequest() {
        String id = GateUtils.generateUUID();
        this.map.put(id, new CallingRequest());
        return id;
    }

    public void writeBytesToCallingRequest(String id, byte[] bytes) throws GateCommException, IOException {
        CallingRequest callingCacheRequest = this.checkRequestId(id);
        callingCacheRequest.write(bytes);
    }

    public MethodCalling finishCallingRequest(String id) throws Exception {
        CallingRequest request = this.checkRequestId(id);
        Object object = request.toObject();
        if (object instanceof MethodCalling) {
            this.map.remove(id);
            return (MethodCalling)object;
        }
        throw new Exception("Invalid class of serialized object " + object.getClass());
    }

    private CallingRequest checkRequestId(String id) throws GateCommException {
        if (!this.map.containsKey(id)) {
            throw new GateCommException("Stream with id \"" + id + "\" doesn't exist");
        }
        Calling methodCallingCache = this.map.get(id);
        if (methodCallingCache.getType() != Calling.TypeOfCache.REQUEST) {
            throw new GateCommException("Stream with id \"" + id + "\" is not a request stream");
        }
        return (CallingRequest)methodCallingCache;
    }

    private CallingResponse checkResponseId(String id) throws GateCommException {
        if (!this.map.containsKey(id)) {
            throw new GateCommException("Stream with id \"" + id + "\" doesn't exist");
        }
        Calling methodCallingCache = this.map.get(id);
        if (methodCallingCache.getType() != Calling.TypeOfCache.RESPONSE) {
            throw new GateCommException("Stream with id \"" + id + "\" is not a response stream");
        }
        return (CallingResponse)methodCallingCache;
    }
}

