/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.repositories.gaterequests;

import com.browsersoft.config.jgate.comm.middlelevel.base.GateRequestWithId;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateResponseWithId;
import com.browsersoft.config.jgate.comm.middlelevel.request.GateRequest;
import com.browsersoft.config.jgate.repositories.gaterequests.GateResponseReceiver;
import com.browsersoft.config.jgate.repositories.gaterequests.StoredGateRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class GateRequestRepositoryItem {
    private Map<String, StoredGateRequest> requests = new HashMap<String, StoredGateRequest>();

    public void addRequest(GateRequest request, GateResponseReceiver handler) {
        StoredGateRequest storedGateRequest = new StoredGateRequest();
        storedGateRequest.setHandler(handler);
        storedGateRequest.setStatus(StoredGateRequest.RequestStatus.WAITING);
        GateRequestWithId gateRequestWithId = new GateRequestWithId();
        gateRequestWithId.setRequest(request);
        gateRequestWithId.setId(UUID.randomUUID().toString());
        storedGateRequest.setGateRequestWithId(gateRequestWithId);
        this.requests.put(gateRequestWithId.getId(), storedGateRequest);
    }

    public List<GateRequestWithId> getRequests() {
        ArrayList<GateRequestWithId> idList = new ArrayList<GateRequestWithId>();
        Set<String> keys = this.requests.keySet();
        for (String key : keys) {
            StoredGateRequest storedGateRequest = this.requests.get(key);
            if (storedGateRequest.getStatus() != StoredGateRequest.RequestStatus.WAITING) continue;
            idList.add(storedGateRequest.getGateRequestWithId());
            storedGateRequest.setStatus(StoredGateRequest.RequestStatus.SENDED);
            storedGateRequest.setGateRequestWithId(null);
        }
        return idList;
    }

    public void responsesReceived(List<GateResponseWithId> responseWithIdList) throws Exception {
        for (GateResponseWithId responseWithId : responseWithIdList) {
            if (!this.requests.containsKey(responseWithId.getId())) {
                return;
            }
            StoredGateRequest storedGateRequest = this.requests.get(responseWithId.getId());
            storedGateRequest.getHandler().responseReceived(responseWithId.getGateResponse());
            this.requests.remove(responseWithId.getId());
        }
    }

    public boolean isEmpty() {
        return this.requests.isEmpty();
    }
}

