/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.repositories.streams;

import com.browsersoft.config.jgate.configuration.GateNodeConfiguration;
import com.browsersoft.config.jgate.exceptions.GateCommException;
import com.browsersoft.config.jgate.repositories.streams.InputStreamRepositoryItem;
import com.browsersoft.config.jgate.repositories.streams.OutputStreamRepositoryItem;
import com.browsersoft.config.jgate.repositories.streams.StreamRepositoryItem;
import com.browsersoft.config.jgate.util.GateUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class StreamsRepository {
    private Map<String, StreamRepositoryItem> streams = new HashMap<String, StreamRepositoryItem>();
    private GateNodeConfiguration configuration;

    public StreamsRepository(GateNodeConfiguration configuration) {
        this.configuration = configuration;
    }

    public synchronized void removeItem(String id) throws GateCommException, IOException {
        this.getItem(id).close();
        this.streams.remove(id);
    }

    public synchronized String newInputStream(InputStream inputStream) {
        int initBufferSize = this.configuration.getInt("STREAMS_REPOSITORY_BUFFER_SIZE", 102400);
        String newUID = GateUtils.generateUUID();
        InputStreamRepositoryItem item = new InputStreamRepositoryItem(initBufferSize);
        item.setLocalInputStream(inputStream);
        this.streams.put(newUID, item);
        return newUID;
    }

    public synchronized String newOutputStream(OutputStream outputStream) {
        int initBufferSize = this.configuration.getInt("STREAMS_REPOSITORY_BUFFER_SIZE", 102400);
        String newUID = GateUtils.generateUUID();
        OutputStreamRepositoryItem item = new OutputStreamRepositoryItem(initBufferSize);
        item.setLocalOutputStream(outputStream);
        this.streams.put(newUID, item);
        return newUID;
    }

    public synchronized boolean contains(String uid) {
        return this.streams.containsKey(uid);
    }

    public synchronized StreamRepositoryItem getItem(String uid) throws GateCommException {
        if (this.streams.containsKey(uid)) {
            return this.streams.get(uid);
        }
        throw new GateCommException("No stream with id \"" + uid + "\"");
    }
}

