/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.util;

import com.browsersoft.config.jgate.exceptions.GateException;
import com.browsersoft.config.jgate.proxy.ServiceCallMethodHandler;
import com.browsersoft.config.jgate.proxy.handlers.SyncMethodHandler;
import com.browsersoft.config.jgate.proxy.handlers.SyncProgressMethodHandler;
import com.browsersoft.config.jgate.util.ObjectInputStreamWithClassLoader;
import com.browsersoft.config.utils.ProgressHandler;
import com.browsersoft.config.utils.streams.SizedInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;

public class GateUtils {
    public static Object deserializeByteArrayToObject(byte[] bytes, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ObjectInputStreamWithClassLoader objectInputStream = new ObjectInputStreamWithClassLoader(byteArrayInputStream, classLoader);
        return objectInputStream.readObject();
    }

    public static void inputStreamToOutputStream(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        GateUtils.inputStreamToOutputStreamWithHandler(inputStream, outputStream, null, bufferSize);
    }

    public static boolean inputStreamToOutputStreamWithHandler(InputStream inputStream, OutputStream outputStream, ProgressHandler handler, int bufferSize) throws IOException {
        long size = inputStream instanceof SizedInputStream ? ((SizedInputStream)inputStream).getSize() : (long)inputStream.available();
        return GateUtils.inputStreamToOutputStreamWithHandler(inputStream, outputStream, handler, size, bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean inputStreamToOutputStreamWithHandler(InputStream inputStream, OutputStream outputStream, ProgressHandler handler, long size, int bufferSize) throws IOException {
        try {
            int length;
            int percent;
            if (size <= 0L) {
                if (handler != null) {
                    boolean bl = handler.processItem(100);
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            if ((long)bufferSize > size) {
                bufferSize = (int)size;
            }
            byte[] buffer = new byte[bufferSize];
            long sum = 0L;
            long remaining = size;
            do {
                if ((length = inputStream.read(buffer)) == -1) return true;
                outputStream.write(buffer, 0, length);
                if (size <= 0L) continue;
                if ((remaining -= (long)length) <= 0L) {
                    return true;
                }
                if (remaining >= (long)buffer.length) continue;
                buffer = new byte[(int)remaining];
            } while (handler == null || size <= 0L || handler.processItem(percent = (int)Math.ceil((double)(sum += (long)length) / (double)size * 100.0)));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {}
        }
    }

    public static void inputStreamToOutputStreamWithHandler(InputStream inputStream, OutputStream outputStream, SyncProgressMethodHandler handler, String message, long size, int bufferSize) throws IOException {
        GateUtils.inputStreamToOutputStreamWithHandler(inputStream, outputStream, percent -> {
            if (handler != null) {
                handler.callingMethodInProgress(SyncMethodHandler.ProgressType.PROCESSING_METHOD, percent, message);
            }
            return true;
        }, size, bufferSize);
    }

    public static boolean inputStreamToOutputStreamWithHandler(InputStream inputStream, OutputStream outputStream, ServiceCallMethodHandler handler, long size, String message) throws IOException {
        return GateUtils.inputStreamToOutputStreamWithHandler(inputStream, outputStream, handler, message, size, 8192);
    }

    public static boolean inputStreamToOutputStreamWithHandler(InputStream inputStream, OutputStream outputStream, ServiceCallMethodHandler handler, String message, long size, int bufferSize) throws IOException {
        return GateUtils.inputStreamToOutputStreamWithHandler(inputStream, outputStream, percent -> {
            if (handler != null) {
                return handler.callingMethodInProgress(percent, message);
            }
            return true;
        }, size, bufferSize);
    }

    public static String generateUUID() {
        return UUID.randomUUID().toString();
    }

    public static Object[] extendParams(Object[] params, Object next) {
        Object[] newParams = new Object[params.length + 1];
        System.arraycopy(params, 0, newParams, 0, params.length);
        newParams[params.length] = next;
        return newParams;
    }

    public static byte[] loadInputStreamToBytes(InputStream inputStream, int lengthOfBuffer) throws IOException {
        int readBytes;
        byte[] data = new byte[lengthOfBuffer];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, lengthOfBuffer);
        int offset = 0;
        while ((readBytes = bufferedInputStream.read(data, offset, lengthOfBuffer - offset)) != -1) {
            offset += readBytes;
        }
        bufferedInputStream.close();
        return data;
    }

    public static byte[] serializeObjectToByteArray(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objStream = new ObjectOutputStream(byteArrayOutputStream);
        objStream.writeObject(object);
        objStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserializeByteArrayToObject(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public static Object deserializeInputStreamToObject(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Object o = objectInputStream.readObject();
        inputStream.close();
        return o;
    }

    public static Exception unwrapGateException(Exception e) {
        Throwable cause3;
        Throwable cause2;
        Throwable cause1 = e.getCause();
        if (cause1 instanceof GateException && (cause2 = cause1.getCause()) instanceof InvocationTargetException && (cause3 = cause2.getCause()) instanceof Exception) {
            return (Exception)cause3;
        }
        return e;
    }
}

