/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.s3cli;

import com.browsersoft.config.s3cli.AesAwsS3Storage;
import com.browsersoft.config.s3cli.S3CliConfiguration;
import org.apache.commons.cli.CommandLine;

public class AesAwsS3Configuration {
    private S3CliConfiguration s3CliConfiguration;
    private String bucket;
    private String aesPassword;

    public static AesAwsS3Configuration from(CommandLine cl) throws Exception {
        AesAwsS3Configuration configuration = new AesAwsS3Configuration();
        configuration.s3CliConfiguration = S3CliConfiguration.from(cl);
        configuration.bucket = cl.getOptionValue("bucket");
        configuration.aesPassword = cl.getOptionValue("aes_password");
        return configuration;
    }

    public AesAwsS3Configuration() {
    }

    public AesAwsS3Configuration(String url, String key, String secret, String region, String bucket, String aesPassword) {
        this.s3CliConfiguration = new S3CliConfiguration(url, region, key, secret);
        this.bucket = bucket;
        this.aesPassword = aesPassword;
    }

    public AesAwsS3Storage getStorage() throws Exception {
        return new AesAwsS3Storage(this.s3CliConfiguration.getStorage(), this);
    }

    public S3CliConfiguration getS3CliConfiguration() {
        return this.s3CliConfiguration;
    }

    public void setS3CliConfiguration(S3CliConfiguration s3CliConfiguration) {
        this.s3CliConfiguration = s3CliConfiguration;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getAesPassword() {
        return this.aesPassword;
    }

    public void setAesPassword(String aesPassword) {
        this.aesPassword = aesPassword;
    }

    public String getUrl() {
        return this.s3CliConfiguration.getUrl();
    }

    public String getRegion() {
        return this.s3CliConfiguration.getRegion();
    }
}

