/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.s3cli;

import com.browsersoft.config.s3cli.AesAwsS3Configuration;
import com.browsersoft.config.s3cli.AesUtils;
import com.browsersoft.config.s3cli.AwsS3Storage;
import com.browsersoft.config.s3cli.ObjectStorage;

public class AesAwsS3Storage
implements ObjectStorage {
    private final AwsS3Storage awsS3Storage;
    private final AesAwsS3Configuration configuration;
    private final String bucket;
    private final String aesPassword;

    public AesAwsS3Storage(AwsS3Storage awsS3Storage, AesAwsS3Configuration configuration) throws Exception {
        this.awsS3Storage = awsS3Storage;
        this.configuration = configuration;
        this.bucket = this.configuration.getBucket();
        this.aesPassword = this.configuration.getAesPassword();
    }

    public boolean objectExist(String fileName) throws Exception {
        if (this.bucket == null) {
            throw new UnsupportedOperationException();
        }
        return this.objectExist(this.bucket, fileName);
    }

    @Override
    public boolean objectExist(String bucket, String fileName) throws Exception {
        return this.awsS3Storage.objectExist(bucket, fileName);
    }

    public void uploadObject(String file, byte[] bytes) throws Exception {
        if (this.bucket == null) {
            throw new UnsupportedOperationException();
        }
        this.uploadObject(this.bucket, file, bytes);
    }

    @Override
    public void uploadObject(String bucket, String file, byte[] bytes) throws Exception {
        byte[] bytesOut = AesUtils.encrypt(bytes, this.aesPassword);
        this.awsS3Storage.uploadObject(bucket, file, bytesOut);
    }

    public byte[] downloadObject(String file) throws Exception {
        if (this.bucket == null) {
            throw new UnsupportedOperationException();
        }
        return this.downloadObject(this.bucket, file);
    }

    @Override
    public byte[] downloadObject(String bucket, String file) throws Exception {
        byte[] bytes = this.awsS3Storage.downloadObject(bucket, file);
        return AesUtils.decrypt(bytes, this.aesPassword);
    }

    @Override
    public void close() {
        this.awsS3Storage.close();
    }

    public AesAwsS3Configuration getConfiguration() {
        return this.configuration;
    }
}

