/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.s3cli;

import com.browsersoft.config.s3cli.ObjectStorage;
import com.browsersoft.config.s3cli.StreamUtils;
import java.io.InputStream;
import java.net.URI;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class AwsS3Storage
implements ObjectStorage {
    private final S3Client client;

    public AwsS3Storage(String url, String accessKey, String secretKey, String region) throws Exception {
        StaticCredentialsProvider credentials = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey));
        this.client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)credentials)).region(Region.of((String)region))).endpointOverride(new URI(url))).build();
    }

    @Override
    public boolean objectExist(String bucket, String fileName) {
        HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(bucket).key(fileName).build();
        try {
            this.client.headObject(headObjectRequest);
            return true;
        }
        catch (NoSuchKeyException e) {
            return false;
        }
    }

    @Override
    public void uploadObject(String bucket, String file, byte[] bytes) {
        PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(bucket).key(file).build();
        this.client.putObject(request, RequestBody.fromBytes((byte[])bytes));
    }

    @Override
    public byte[] downloadObject(String bucket, String file) throws Exception {
        GetObjectRequest request1 = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(file).build();
        return StreamUtils.loadInputStreamToBytes((InputStream)this.client.getObject(request1));
    }

    @Override
    public void close() {
        this.client.close();
    }
}

