/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.s3cli;

import com.browsersoft.config.s3cli.AwsS3Storage;
import com.browsersoft.config.s3cli.S3CliConfiguration;
import com.browsersoft.config.s3cli.StreamUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class S3Cli {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void run(String[] rawArgs) throws Exception {
        String cmd;
        CommandLine cl;
        try {
            DefaultParser parser = new DefaultParser();
            cl = parser.parse(this.getOptions(), rawArgs);
        }
        catch (MissingOptionException e) {
            S3Cli.printUsage(e.getMessage());
            System.exit(1);
            return;
        }
        S3CliConfiguration cfg = S3CliConfiguration.from(cl);
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(cl.getArgs()));
        if (args.size() < 1) {
            S3Cli.printUsage("Missing required 'cmd' argument");
            System.exit(1);
        }
        switch (cmd = (String)args.remove(0)) {
            case "get": {
                S3Cli.doGet(cfg, args);
                break;
            }
            case "list": {
                this.doList(cfg, args);
                break;
            }
            default: {
                S3Cli.printUsage("Unknown command '" + cmd + "'");
                System.exit(1);
            }
        }
    }

    public static String doGet(S3CliConfiguration cfg, List<String> args) throws Exception {
        Object destinationPath;
        Pattern pattern;
        Matcher matcher;
        if (args.size() < 1) {
            S3Cli.printUsage("Missing required parameter 'bucket-path'");
            System.exit(1);
        }
        if (!(matcher = (pattern = Pattern.compile("^(?<bucket>[^\\/]+)\\/(?<path>[^\\/]+\\S*)")).matcher(args.get(0))).matches()) {
            S3Cli.printUsage("Parameter 'bucket-path' has to have format '<bucket>/<path>'");
            System.exit(1);
        }
        String bucket = matcher.group("bucket");
        String path = matcher.group("path");
        AwsS3Storage client = cfg.getStorage();
        byte[] bytes = client.downloadObject(bucket, path);
        int lastSlashIndex = path.lastIndexOf("/");
        String filename = lastSlashIndex > -1 ? path.substring(lastSlashIndex + 1) : path;
        if (args.size() > 1) {
            destinationPath = args.get(1);
            File dest = new File((String)destinationPath);
            if (dest.exists() && dest.isDirectory() || ((String)destinationPath).endsWith("/")) {
                if (!((String)destinationPath).endsWith("/")) {
                    destinationPath = (String)destinationPath + "/";
                }
                destinationPath = (String)destinationPath + filename;
            }
        } else {
            destinationPath = filename;
        }
        StreamUtils.saveBytesToFile(new File((String)destinationPath), bytes);
        return destinationPath;
    }

    private void doList(S3CliConfiguration cfg, List<String> args) {
    }

    private static void printUsage(String error) {
        if (error != null && !error.isEmpty()) {
            System.out.println(error);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("s3cli <options> <cmd>...", null, S3Cli.getOptions(), null, false);
    }

    public static Options getOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"k").longOpt("key").hasArg(true).numberOfArgs(1).argName("key").required(true).build());
        options.addOption(Option.builder((String)"s").longOpt("secret").argName("secret").hasArg(true).numberOfArgs(1).required(true).build());
        options.addOption(Option.builder((String)"u").longOpt("url").hasArg(true).numberOfArgs(1).argName("url").required(true).build());
        options.addOption(Option.builder((String)"r").longOpt("region").hasArg(true).numberOfArgs(1).argName("region").required(false).build());
        return options;
    }

    public static void copyStream(InputStream in, OutputStream out, long length) throws IOException {
        int read;
        long remaining = length;
        byte[] buffer = new byte[(int)Math.min(2048L, remaining)];
        while ((read = in.read(buffer)) != -1 && remaining > 0L) {
            out.write(buffer, 0, read);
            if ((remaining -= (long)read) >= (long)buffer.length) continue;
            buffer = new byte[(int)remaining];
        }
    }

    private String formatSize(long size) {
        int i;
        long base = 1024L;
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        float localSize = size;
        for (i = 0; i < units.length && localSize >= 1024.0f; localSize /= 1024.0f, ++i) {
        }
        DecimalFormat format = new DecimalFormat();
        format.setMaximumFractionDigits(2);
        return String.format("%s %s", format.format(localSize), units[i]);
    }

    public static void main(String[] args) {
        try {
            new S3Cli().run(args);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }
}

