/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.s3cli;

import com.browsersoft.config.s3cli.AesAwsS3Configuration;
import com.browsersoft.config.s3cli.AesAwsS3Storage;
import com.browsersoft.config.s3cli.ObjectStorage;
import com.browsersoft.config.s3cli.S3Cli;
import com.browsersoft.config.s3cli.StreamUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class S3DeploymentDownloader {
    public static void main(String[] args) {
        try {
            new S3DeploymentDownloader().run(args);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }

    public void run(String[] rawArgs) throws Exception {
        String cmd;
        CommandLine cl;
        try {
            DefaultParser parser = new DefaultParser();
            cl = parser.parse(this.getOptions(), rawArgs);
        }
        catch (MissingOptionException e) {
            this.printUsage(e.getMessage());
            System.exit(1);
            return;
        }
        AesAwsS3Configuration cfg = AesAwsS3Configuration.from(cl);
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(cl.getArgs()));
        if (args.size() < 1) {
            this.printUsage("Missing required 'cmd' argument");
            System.exit(1);
        }
        switch (cmd = (String)args.remove(0)) {
            case "download": {
                this.doDownload(cfg, args);
                break;
            }
            default: {
                this.printUsage("Unknown command '" + cmd + "'");
                System.exit(1);
            }
        }
    }

    private void doDownload(AesAwsS3Configuration cfg, List<String> args) throws Exception {
        if (args.size() < 1) {
            this.printUsage("Missing required parameter 'bucket-path'");
            System.exit(1);
        }
        AesAwsS3Storage client = cfg.getStorage();
        String id = args.get(0);
        if (args.size() < 2) {
            this.printUsage("Missing required parameter 'out-path'");
            System.exit(1);
        }
        String out = args.get(1);
        this.downloadFileAndUnzipFileFromS3(client, cfg.getBucket(), "deployments/" + id, id, args.get(1));
        try (BufferedReader reader = new BufferedReader(new FileReader(new File(out, "dirs.txt")));){
            String line = reader.readLine();
            while (line != null) {
                String[] values = line.split("#", -1);
                if (values.length != 2) {
                    System.out.println("Invalid line" + line);
                    System.exit(1);
                }
                String dirName = values[0];
                String fileName = values[1];
                this.downloadFileAndUnzipFileFromS3(client, cfg.getBucket(), "dirs/" + fileName, fileName, new File(out, dirName).getAbsolutePath());
                line = reader.readLine();
            }
        }
        File file = new File(out, "jars.txt");
        if (file.exists()) {
            File outEngineControl;
            File outLib = new File(new File(out).getParent(), "lib");
            if (!outLib.exists()) {
                outLib.mkdirs();
            }
            if (!(outEngineControl = new File(new File(out), "engine_control")).exists()) {
                outEngineControl.mkdirs();
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line = reader.readLine();
                while (line != null) {
                    String[] values = line.split("#", -1);
                    if (values.length != 2) {
                        System.out.println("Invalid line" + line);
                        System.exit(1);
                    }
                    String jarName = values[0];
                    String fileName = values[1];
                    System.out.println("downloading :" + fileName);
                    byte[] bytes = client.downloadObject(cfg.getBucket(), "jars/" + fileName);
                    File outFile = new File(out, jarName);
                    System.out.println("saving to file :" + outFile);
                    StreamUtils.saveBytesToFile(outFile, bytes);
                    System.out.println("ok");
                    line = reader.readLine();
                }
            }
        }
    }

    private void downloadFileAndUnzipFileFromS3(ObjectStorage client, String bucket, String fileName, String outFileName, String outDirPath) throws Exception {
        System.out.println("downloading :" + fileName + " from bucket " + bucket);
        byte[] bytes = client.downloadObject(bucket, fileName);
        File outFile = new File(".", outFileName);
        System.out.println("saving to :" + outFile);
        StreamUtils.saveBytesToFile(outFile, bytes);
        File outDir = new File(outDirPath);
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        System.out.println("unzip to :" + outDir);
        S3DeploymentDownloader.unpackZip(outFile, outDir);
        System.out.println("deleting :" + outFile);
        outFile.delete();
    }

    public static void unpackZip(File inputFile, File destination) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(inputFile);
             ZipInputStream zin = new ZipInputStream(inputStream);){
            ZipEntry ze;
            while ((ze = zin.getNextEntry()) != null) {
                File file = new File(destination, ze.getName());
                if (ze.isDirectory()) {
                    if (!file.exists()) {
                        file.mkdir();
                    }
                    zin.closeEntry();
                    continue;
                }
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                try (FileOutputStream fout = new FileOutputStream(file);){
                    int r;
                    byte[] buf = new byte[4096];
                    while ((r = zin.read(buf)) != -1) {
                        fout.write(buf, 0, r);
                    }
                    zin.closeEntry();
                }
            }
        }
    }

    private Options getOptions() {
        Options options = S3Cli.getOptions();
        options.addOption(Option.builder((String)"b").longOpt("bucket").hasArg(true).numberOfArgs(1).argName("bucket").required(true).build());
        options.addOption(Option.builder((String)"p").longOpt("aes_password").hasArg(true).numberOfArgs(1).argName("aes_password").required(true).build());
        return options;
    }

    private void printUsage(String error) {
        if (error != null && !error.isEmpty()) {
            System.out.println(error);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("s3downloader <options> <cmd>...", null, this.getOptions(), null, false);
    }
}

