/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.s3cli;

import ch.qos.logback.classic.Level;
import com.browsersoft.config.s3cli.AesAwsS3Configuration;
import com.browsersoft.config.s3cli.AesAwsS3Storage;
import com.browsersoft.config.s3cli.ObjectStorage;
import com.browsersoft.config.s3cli.S3Cli;
import com.browsersoft.config.s3cli.StreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class S3DeploymentsUploader {
    private static final Logger log = LoggerFactory.getLogger(S3DeploymentsUploader.class);

    public static void main(String[] args) throws Exception {
        new S3DeploymentsUploader().run(args);
    }

    public void run(String[] rawArgs) throws Exception {
        String deploymentsPath;
        File deploymentsDir;
        CommandLine cl;
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        try {
            DefaultParser parser = new DefaultParser();
            cl = parser.parse(this.getOptions(), rawArgs);
        }
        catch (MissingOptionException e) {
            this.printUsage(e.getMessage());
            System.exit(1);
            return;
        }
        String logLevelStr = cl.getOptionValue("log-level", "info");
        if (logLevelStr != null && !logLevelStr.isBlank()) {
            ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
            root.setLevel(Level.valueOf((String)logLevelStr));
        }
        AesAwsS3Configuration cfg = AesAwsS3Configuration.from(cl);
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(cl.getArgs()));
        if (args.size() < 2) {
            this.printUsage("Missing required 'path' or 'helm-values-file-path' argument");
            System.exit(1);
        }
        if (!(deploymentsDir = new File(deploymentsPath = (String)args.get(0))).isDirectory()) {
            log.error("Invalid path to deployments directory: " + deploymentsDir.getAbsolutePath());
            System.exit(1);
            return;
        }
        String containerImagePath = cl.getOptionValue("container-image-path");
        if (containerImagePath.contains(":")) {
            log.error("container-image-path parameter has to be only base path. Cannot contain ':' character.");
        }
        File helmChartValuesFile = new File((String)args.get(1));
        this.doUpload(cfg.getStorage(), deploymentsDir, helmChartValuesFile, containerImagePath);
    }

    private void doUpload(AesAwsS3Storage s3, File deploymentsDir, File helmChartValuesFile, String containerImagePath) throws Exception {
        List<String> deploymentNames = this.listDirectory(deploymentsDir, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
        if (deploymentNames.isEmpty()) {
            log.error("No deployment directories found. Terminating.");
            System.exit(1);
            return;
        }
        log.info("");
        log.info("Found deployments: ");
        for (String string : deploymentNames) {
            log.info(" - " + string);
        }
        log.info("");
        HashMap<String, String> deploymentZipFiles = new HashMap<String, String>();
        for (String deploymentName : deploymentNames) {
            log.info("Processing deployment '{}'", (Object)deploymentName);
            File deploymentDir = new File(deploymentsDir, deploymentName);
            String filename = this.uploadDeployment(s3, deploymentDir);
            deploymentZipFiles.put(deploymentName, filename);
        }
        if (helmChartValuesFile != null) {
            byte[] byArray;
            File releaseNameFile = new File(deploymentsDir, deploymentNames.get(0) + "/release.txt");
            try (FileInputStream in = new FileInputStream(releaseNameFile);){
                byArray = StreamUtils.loadInputStreamToBytes(in);
            }
            String releaseName = new String(byArray, StandardCharsets.UTF_8);
            this.createHelmChartValuesFile(helmChartValuesFile, s3.getConfiguration(), containerImagePath, releaseName, deploymentZipFiles);
        }
        log.info("");
        log.info("Done.");
    }

    private void createHelmChartValuesFile(File helmChartValuesFile, AesAwsS3Configuration s3Configuration, String containerImagePath, String releaseName, Map<String, String> deploymentZipFiles) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("engine:\n");
        sb.append("  image: ").append(containerImagePath).append(":").append(releaseName).append("\n");
        sb.append("\n");
        sb.append("objectStorage:\n");
        sb.append("  url: ").append(s3Configuration.getUrl()).append("\n");
        sb.append("  region: ").append(s3Configuration.getRegion()).append("\n");
        sb.append("  bucket: ").append(s3Configuration.getBucket()).append("\n");
        sb.append("  paths:\n");
        Iterator<Map.Entry<String, String>> iterator = deploymentZipFiles.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String name = entry.getKey();
            String filename = entry.getValue();
            sb.append("    ").append(name).append(": ");
            sb.append("\"").append(filename).append("\"");
            if (!iterator.hasNext()) continue;
            sb.append("\n");
        }
        StreamUtils.saveBytesToFile(helmChartValuesFile, sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    private String uploadDeployment(AesAwsS3Storage s3, File deploymentDir) throws Exception {
        StringBuilder sb = new StringBuilder();
        List<String> configDirNames = this.listDirectory(deploymentDir, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
        Iterator<String> iterator = configDirNames.iterator();
        while (iterator.hasNext()) {
            String configDirName = iterator.next();
            log.info(" - configDir '{}'", (Object)configDirName);
            File configDir = new File(deploymentDir, configDirName);
            String filename = this.uploadConfigDir(s3, configDir);
            sb.append(configDirName).append("#").append(filename);
            if (!iterator.hasNext()) continue;
            sb.append("\n");
        }
        return this.uploadDeploymentZip(s3, deploymentDir, sb.toString());
    }

    private String uploadDeploymentZip(AesAwsS3Storage s3, File deploymentDir, String dirsStr) throws Exception {
        String configHash = null;
        String profileHash = null;
        String releaseName = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ZipOutputStream zip = new ZipOutputStream(out);){
            List<String> filenames = this.listDirectory(deploymentDir, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
            for (String filename : filenames) {
                byte[] bytes;
                File file = new File(deploymentDir, filename);
                try (FileInputStream in = new FileInputStream(file);){
                    bytes = StreamUtils.loadInputStreamToBytes(in);
                }
                this.zipAddFile(zip, Paths.get(filename, new String[0]), bytes);
                switch (filename) {
                    case "config.xml": {
                        configHash = this.hash(bytes);
                        break;
                    }
                    case "profile.xml": {
                        profileHash = this.hash(bytes);
                        break;
                    }
                    case "release.txt": {
                        releaseName = new String(bytes, StandardCharsets.UTF_8);
                    }
                }
            }
            this.zipAddFile(zip, Paths.get("dirs.txt", new String[0]), dirsStr.getBytes(StandardCharsets.UTF_8));
        }
        log.debug("Config hash: {}", configHash);
        log.debug("Profile hash: {}", profileHash);
        log.debug("Release name: {}", releaseName);
        Object unique = deploymentDir.getName() + "#" + releaseName + "#" + configHash + "#" + profileHash + "#" + dirsStr;
        unique = this.hash(((String)unique).getBytes(StandardCharsets.UTF_8));
        String filename = String.format("%s-%s.zip", deploymentDir.getName(), unique);
        String filepath = "deployments/" + filename;
        this.uploadToS3(s3, filepath, out.toByteArray());
        return filename;
    }

    private String uploadConfigDir(AesAwsS3Storage s3, File configDir) throws Exception {
        byte[] zipBytes = this.zipDir(configDir);
        String hash = this.hash(zipBytes);
        log.info("   - zip size: {}", (Object)zipBytes.length);
        log.info("   - hash: {}", (Object)hash);
        String filename = String.format("%s-%s.zip", configDir.getName(), hash);
        String filepath = "dirs/" + filename;
        this.uploadToS3(s3, filepath, zipBytes);
        return filename;
    }

    private void uploadToS3(AesAwsS3Storage s3, String filepath, byte[] data) throws Exception {
        if (s3.objectExist(filepath)) {
            log.info(" - file '{}' already exists in object storage. Skipping.", (Object)filepath);
            return;
        }
        log.info(" - uploading file '{}'", (Object)filepath);
        s3.uploadObject(filepath, data);
    }

    private String hash(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest m = MessageDigest.getInstance("sha1");
        m.update(bytes, 0, bytes.length);
        byte[] hash = m.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : hash) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    private byte[] zipDir(File dir) throws IOException {
        Path configDirPath = dir.toPath();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ZipOutputStream zip = new ZipOutputStream(out);
             Stream<Path> walk = Files.walk(configDirPath, new FileVisitOption[0]);){
            AtomicReference e = new AtomicReference();
            walk.takeWhile(p -> e.get() == null).forEachOrdered(p -> {
                if (p.equals(configDirPath)) {
                    return;
                }
                Path path = configDirPath.relativize((Path)p);
                log.debug("   - " + path);
                try {
                    File file = p.toFile();
                    if (file.isDirectory()) {
                        this.zipAddDir(zip, path);
                    } else if (file.isFile()) {
                        this.zipAddFile(zip, path, file);
                    }
                }
                catch (IOException e1) {
                    e.set(e1);
                }
            });
            if (e.get() != null) {
                throw (IOException)e.get();
            }
        }
        return out.toByteArray();
    }

    private void zipAddDir(ZipOutputStream zip, Path path) throws IOException {
        ZipEntry zipEntry = new ZipEntry(path.toString() + "/");
        zipEntry.setTime(0L);
        zip.putNextEntry(zipEntry);
        zip.closeEntry();
    }

    private void zipAddFile(ZipOutputStream zip, Path path, File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            ZipEntry zipEntry = new ZipEntry(path.toString());
            zipEntry.setTime(0L);
            zip.putNextEntry(zipEntry);
            StreamUtils.inputStreamToOutputStream(in, zip);
            zip.closeEntry();
        }
    }

    private void zipAddFile(ZipOutputStream zip, Path path, byte[] bytes) throws IOException {
        ZipEntry zipEntry = new ZipEntry(path.toString());
        zipEntry.setTime(0L);
        zip.putNextEntry(zipEntry);
        zip.write(bytes);
        zip.closeEntry();
    }

    private List<String> listDirectory(File dir, Predicate<Path> filter) throws IOException {
        Set ret;
        try (Stream<Path> stream = Files.list(dir.toPath());){
            ret = stream.filter(filter).map(Path::getFileName).map(Path::toString).collect(Collectors.toSet());
        }
        ArrayList<String> retList = new ArrayList<String>(ret);
        retList.sort(Comparator.naturalOrder());
        return retList;
    }

    private void downloadFileAndUnzipFileFromS3(ObjectStorage s3, String bucket, String fileName, String outFileName, String outDirPath) throws Exception {
        System.out.println("downloading :" + fileName + " from bucket " + bucket);
        byte[] bytes = s3.downloadObject(bucket, fileName);
        File outFile = new File(".", outFileName);
        System.out.println("saving to :" + outFile);
        StreamUtils.saveBytesToFile(outFile, bytes);
        File outDir = new File(outDirPath);
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        System.out.println("unzip to :" + outDir);
        S3DeploymentsUploader.unpackZip(outFile, outDir);
        System.out.println("deleting :" + outFile);
        outFile.delete();
    }

    public static void unpackZip(File inputFile, File destination) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(inputFile);
             ZipInputStream zin = new ZipInputStream(inputStream);){
            ZipEntry ze;
            while ((ze = zin.getNextEntry()) != null) {
                File file = new File(destination, ze.getName());
                if (ze.isDirectory()) {
                    if (!file.exists()) {
                        file.mkdir();
                    }
                    zin.closeEntry();
                    continue;
                }
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                try (FileOutputStream fout = new FileOutputStream(file);){
                    int r;
                    byte[] buf = new byte[4096];
                    while ((r = zin.read(buf)) != -1) {
                        fout.write(buf, 0, r);
                    }
                    zin.closeEntry();
                }
            }
        }
    }

    private Options getOptions() {
        Options options = S3Cli.getOptions();
        options.addOption(Option.builder((String)"b").longOpt("bucket").hasArg(true).numberOfArgs(1).argName("bucket").required(true).build());
        options.addOption(Option.builder((String)"p").longOpt("aes_password").hasArg(true).numberOfArgs(1).argName("aes_password").required(true).build());
        options.addOption(Option.builder((String)"i").longOpt("container-image-path").hasArg(true).numberOfArgs(1).argName("container-image-path").required(true).build());
        options.addOption(Option.builder((String)"l").longOpt("log-level").hasArg(true).numberOfArgs(1).argName("log-level").required(false).build());
        return options;
    }

    private void printUsage(String error) {
        if (error != null && !error.isEmpty()) {
            System.out.println(error);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("s3uploader <options> <deployments-path> <helmchart-values-path>", null, this.getOptions(), null, false);
    }
}

