#!/bin/bash
#
# kubenode    Kubernetes node 1.0 for managing HIE Engine instances inside kubernetes cluster
#
# chkconfig: 345 70 30
# description: Kubernetes node 1.0 for managing HIE Engine instances inside kubernetes cluster
# processname: node

### BEGIN INIT INFO
# Provides: node
# Required-Start: $local_fs
# Required-Stop: $stop_fs
# Default-Start: 3 5
# Default-Stop: 0 1 2 6
# Short-Description: Kubernetes node 1.0 for managing HIE Engine instances inside kubernetes cluster
# Description: Kubernetes node 1.0 for managing HIE Engine instances inside kubernetes cluster
### END INIT INFO

USER="browsersoft"
ROOT="/opt/browsersoft/kubenode"

# Source function library.
. /etc/init.d/functions

start() {
        echo -n "Starting KubeNode: "
        su - ${USER} -c "${ROOT}/kubenode.sh start"
        ret=$?
        touch /var/lock/subsys/kubenode
        return $ret
}

stop() {
        echo -n "Shutting down KubeNode: "
        su - ${USER} -c "${ROOT}/kubenode.sh stop"
        ret=$?
        rm -f /var/lock/subsys/kubenode
        return $ret
}

case "$1" in
    start)
        start
        ;;
    stop)
        stop
        ;;
    *)
        echo "Usage: $0 [start|stop]"
        exit 1
        ;;
esac

exit $?