#!/bin/sh

CURDIR="$PWD"
NODEDIR=$( cd -P -- "$(dirname -- "$0")" && pwd -P )

cd "$NODEDIR"

JAVA_OPTS="$JAVA_OPTS -Xmx512M -Duser.timezone=UTC -Djava.awt.headless=true"

case $1 in
start)

  if [ -f "$NODEDIR/kubenode.pid" ] ; then
    if [ -d "/proc/$(cat $NODEDIR/kubenode.pid)" ] ; then
      echo "KubeNode seems to be running."
      exit 1
    else
      unlink "$NODEDIR/kubenode.pid"
    fi
  fi

  if [ -f "$NODEDIR/kubenode.out" ] ; then
    if [ ! -d "$NODEDIR/logs" ] ; then
        mkdir $NODEDIR/logs
      fi
    logrotate -f $NODEDIR/logrotate.conf -s $NODEDIR/logstatus
  fi

  java $JAVA_OPTS -classpath "libs/*" com.browsersoft.config.kubenode.KubeNode $NODEDIR/config.xml &> $NODEDIR/kubenode.out &
  echo "$!" > $NODEDIR/kubenode.pid

  ;;
stop)

  if [ ! -f "$NODEDIR/kubenode.pid" ] ; then
    echo "KubeNode is not running"
  else
    pid=$(cat "$NODEDIR/kubenode.pid")
    if [ -d "/proc/$pid" ] ; then
      kill $pid
    fi
    unlink "$NODEDIR/kubenode.pid"
  fi

  ;;
*)

  echo "Parameters can be either start or stop"

  ;;
esac

cd "$CURDIR"
