/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.node;

import com.browsersoft.config.api.StaticTransferableFileStorage;
import com.browsersoft.config.api.TransferableFileStorage;
import com.browsersoft.config.jgate.GateServerConfiguration;
import com.browsersoft.config.utils.DOMUtils;
import java.io.File;
import org.w3c.dom.Node;

public class ReleaseNodeConfiguration {
    private File root;
    private File deploymentsRoot;
    private String userName;
    private String password;
    private String javaBinDir;
    private String oracleLibraryDir;
    private String oracleDriverPath;
    private File nodeRoot;
    private String auditorUrl;
    private String auditorToken;
    private String auditorNodeId;
    private int auditorTimeout;
    private boolean auditorSkipCertificateCheck;
    private TransferableFileStorage jarStorage;
    private TransferableFileStorage dirStorage;
    private GateServerConfiguration gateServerConfiguration;

    public ReleaseNodeConfiguration(Node node) throws Exception {
        Node repositoryNode = DOMUtils.getOneNodeChild((Node)node, (String)"repository");
        this.root = new File(DOMUtils.getParameter((Node)repositoryNode, (String)"root"));
        this.jarStorage = new StaticTransferableFileStorage(new File(this.root, "jars"));
        this.dirStorage = new StaticTransferableFileStorage(new File(this.root, "dirs"));
        this.deploymentsRoot = new File(this.root, "deployments");
        if (!this.deploymentsRoot.exists()) {
            this.deploymentsRoot.mkdir();
        }
        Node upgradeNode = DOMUtils.getOneNodeChild((Node)node, (String)"upgrade");
        this.nodeRoot = new File(DOMUtils.getParameter((Node)upgradeNode, (String)"nodeRoot"));
        Node serverNode = DOMUtils.getOneNodeChild((Node)node, (String)"server");
        this.gateServerConfiguration = new GateServerConfiguration(serverNode);
        Node accessNode = DOMUtils.getOneNodeChild((Node)node, (String)"access");
        this.userName = DOMUtils.getParameter((Node)accessNode, (String)"user");
        this.password = DOMUtils.getParameter((Node)accessNode, (String)"password");
        Node engineNode = DOMUtils.getOneNodeChild((Node)node, (String)"engine");
        this.javaBinDir = DOMUtils.getParameter((Node)engineNode, (String)"javaBinDir", (String)"/opt/browsersoft/java/bin");
        this.oracleLibraryDir = DOMUtils.getParameter((Node)engineNode, (String)"oracleLibraryDir", (String)"/opt/browsersoft/oci-driver");
        this.oracleDriverPath = DOMUtils.getParameter((Node)engineNode, (String)"oracleDriverPath", (String)"/opt/browsersoft/oci-driver/ojdbc6.jar");
        Node auditorNode = DOMUtils.getOneNodeChild((Node)node, (String)"auditor");
        if (auditorNode != null) {
            this.auditorUrl = DOMUtils.getParameter((Node)auditorNode, (String)"url");
            this.auditorToken = DOMUtils.getParameter((Node)auditorNode, (String)"token", (String)"").trim();
            this.auditorNodeId = DOMUtils.getParameter((Node)auditorNode, (String)"nodeId", (String)"");
            this.auditorTimeout = DOMUtils.getIntParameter((Node)auditorNode, (String)"timeout", (int)5000);
            this.auditorSkipCertificateCheck = DOMUtils.getBooleanParameter((Node)auditorNode, (String)"skipCertificateCheck", (boolean)false);
        }
    }

    public File getRoot() {
        return this.root;
    }

    public void setRoot(File root) {
        this.root = root;
    }

    public File getDeploymentsRoot() {
        return this.deploymentsRoot;
    }

    public void setDeploymentsRoot(File deploymentsRoot) {
        this.deploymentsRoot = deploymentsRoot;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public GateServerConfiguration getGateServerConfiguration() {
        return this.gateServerConfiguration;
    }

    public void setGateServerConfiguration(GateServerConfiguration gateServerConfiguration) {
        this.gateServerConfiguration = gateServerConfiguration;
    }

    public TransferableFileStorage getJarStorage() {
        return this.jarStorage;
    }

    public void setJarStorage(TransferableFileStorage jarStorage) {
        this.jarStorage = jarStorage;
    }

    public TransferableFileStorage getDirStorage() {
        return this.dirStorage;
    }

    public void setDirStorage(TransferableFileStorage dirStorage) {
        this.dirStorage = dirStorage;
    }

    public String getJavaBinDir() {
        return this.javaBinDir;
    }

    public void setJavaBinDir(String javaBinDir) {
        this.javaBinDir = javaBinDir;
    }

    public String getOracleLibraryDir() {
        return this.oracleLibraryDir;
    }

    public void setOracleLibraryDir(String oracleLibraryDir) {
        this.oracleLibraryDir = oracleLibraryDir;
    }

    public String getOracleDriverPath() {
        return this.oracleDriverPath;
    }

    public void setOracleDriverPath(String oracleDriverPath) {
        this.oracleDriverPath = oracleDriverPath;
    }

    public File getNodeRoot() {
        return this.nodeRoot;
    }

    public void setNodeRoot(File nodeRoot) {
        this.nodeRoot = nodeRoot;
    }

    public File getUpdatePath() {
        return new File(this.nodeRoot, "deploy");
    }

    public void setAuditorUrl(String auditorUrl) {
        this.auditorUrl = auditorUrl;
    }

    public String getAuditorUrl() {
        return this.auditorUrl;
    }

    public void setAuditorToken(String auditorToken) {
        this.auditorToken = auditorToken;
    }

    public String getAuditorToken() {
        return this.auditorToken;
    }

    public void setAuditorTimeout(int auditorTimeout) {
        this.auditorTimeout = auditorTimeout;
    }

    public int getAuditorTimeout() {
        return this.auditorTimeout;
    }

    public void setAuditorSkipCertificateCheck(boolean auditorSkipCertificateCheck) {
        this.auditorSkipCertificateCheck = auditorSkipCertificateCheck;
    }

    public boolean isAuditorSkipCertificateCheck() {
        return this.auditorSkipCertificateCheck;
    }

    public void setAuditorNodeId(String auditorNodeId) {
        this.auditorNodeId = auditorNodeId;
    }

    public String getAuditorNodeId() {
        return this.auditorNodeId;
    }
}

