/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow;

import com.browsersoft.commander.commanderwindow.JNodeCommanderAppLayoutHandler;
import com.browsersoft.commander.commanderwindow.MainApp;
import com.browsersoft.commander.commanderwindow.error.ErrorManager;
import com.browsersoft.commander.model.CommanderPlugDocument;
import com.browsersoft.commander.model.CommanderPlugDocumentCollection;
import com.browsersoft.commander.utils.swing.CloseableTabbedPane;
import com.browsersoft.commander.utils.swing.CloseableTabbedPaneHandler;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JSplitPane;

public class JNodeCommanderAppLayout
implements CloseableTabbedPaneHandler {
    private CloseableTabbedPane tabbedPane = new CloseableTabbedPane();
    private JSplitPane split;
    private JNodeCommanderAppLayoutHandler handler;

    public JNodeCommanderAppLayout(MainApp commander) {
        this.tabbedPane.setHandler(this);
        this.split = new JSplitPane(1, commander, this.tabbedPane);
        this.split.setOneTouchExpandable(true);
    }

    public void setSplitLocation(int size) {
        this.split.setDividerLocation(size);
    }

    public JSplitPane getRootComponent() {
        return this.split;
    }

    public void removeTab() {
        this.tabbedPane.remove(this.tabbedPane.getSelectedIndex());
    }

    public void addTab(CommanderPlugDocument commanderPlugDocument) {
        String title = this.assembleTitle(null, commanderPlugDocument);
        this.tabbedPane.addTab(title, commanderPlugDocument.getIcon(), (Component)((Object)commanderPlugDocument));
    }

    public void updateTitles() {
        int i;
        for (i = 0; i < this.tabbedPane.getComponentCount(); ++i) {
            Component tabComponent;
            int tabIndexForComponent;
            Component component = this.tabbedPane.getComponent(i);
            if (!(component instanceof CommanderPlugDocument) || (tabIndexForComponent = this.tabbedPane.indexOfComponent(component)) == -1 || !((tabComponent = this.tabbedPane.getTabComponentAt(tabIndexForComponent)) instanceof CloseableTabbedPane.TabCloseButton)) continue;
            String title = this.assembleTitle(i, (CommanderPlugDocument)((Object)component));
            ((CloseableTabbedPane.TabCloseButton)tabComponent).setTitle(title);
        }
        for (i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            Component tabComponent = this.tabbedPane.getTabComponentAt(i);
            if (!(tabComponent instanceof CloseableTabbedPane.TabCloseButton)) continue;
            if (i == this.tabbedPane.getSelectedIndex()) {
                ((CloseableTabbedPane.TabCloseButton)tabComponent).setBoldFont();
                continue;
            }
            ((CloseableTabbedPane.TabCloseButton)tabComponent).setPlainFont();
        }
    }

    private String assembleTitle(Integer index, CommanderPlugDocument document) {
        String title;
        String suffix;
        String prefix = document.getTitlePrefix();
        if (prefix == null) {
            prefix = "";
        }
        if ((suffix = document.getTitleSuffix()) == null) {
            suffix = "";
        }
        if ((title = document.getTitle()) == null) {
            int i;
            ArrayList<String> path = new ArrayList<String>(document.getPath());
            if (path.isEmpty()) {
                return "Unknown";
            }
            Collections.reverse(path);
            List<List<String>> reversedTabsPaths = this.getReversedTabTitlePaths(index);
            for (i = 0; i < path.size(); ++i) {
                String pathItem = (String)path.get(i);
                Iterator<List<String>> iterator = reversedTabsPaths.iterator();
                while (iterator.hasNext()) {
                    List<String> tabPath = iterator.next();
                    if (tabPath.size() < i + 1) {
                        iterator.remove();
                        continue;
                    }
                    String tabPathItem = tabPath.get(i);
                    if (pathItem.equals(tabPathItem)) continue;
                    iterator.remove();
                }
                if (reversedTabsPaths.isEmpty()) break;
            }
            if (reversedTabsPaths.isEmpty()) {
                List titleParts = path.subList(0, i + 1);
                Collections.reverse(titleParts);
                title = String.join((CharSequence)File.separator, titleParts);
            } else {
                title = (String)path.get(0);
            }
        }
        return String.format("%s%s%s", prefix, title, suffix);
    }

    private List<List<String>> getReversedTabTitlePaths(Integer excludedIndex) {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        for (int i = 0; i < this.tabbedPane.getComponentCount(); ++i) {
            Component tabComponent;
            int tabIndexForComponent;
            Component component = this.tabbedPane.getComponent(i);
            if (excludedIndex != null && excludedIndex == i || !(component instanceof CommanderPlugDocument) || (tabIndexForComponent = this.tabbedPane.indexOfComponent(component)) == -1 || !((tabComponent = this.tabbedPane.getTabComponentAt(tabIndexForComponent)) instanceof CloseableTabbedPane.TabCloseButton)) continue;
            CommanderPlugDocument document = (CommanderPlugDocument)((Object)component);
            if (document.getTitle() != null) {
                ArrayList<String> tmp = new ArrayList<String>();
                tmp.add(document.getTitle());
                ret.add(tmp);
                continue;
            }
            ArrayList<String> path = new ArrayList<String>(document.getPath());
            Collections.reverse(path);
            ret.add(path);
        }
        return ret;
    }

    @Override
    public void tabbedPanelChanged() {
        if (this.handler != null) {
            this.handler.somethingInTabsChanged();
        }
    }

    public CommanderPlugDocumentCollection getAllDocuments() {
        CommanderPlugDocumentCollection collection = new CommanderPlugDocumentCollection();
        for (int i = 0; i < this.tabbedPane.getComponentCount(); ++i) {
            Component component = this.tabbedPane.getComponent(i);
            if (!(component instanceof CommanderPlugDocument)) continue;
            collection.add((CommanderPlugDocument)((Object)component));
        }
        return collection;
    }

    public CommanderPlugDocument getActualDocument() {
        return (CommanderPlugDocument)((Object)this.tabbedPane.getSelectedComponent());
    }

    @Override
    public boolean closeTab(int i) {
        try {
            CommanderPlugDocument document = (CommanderPlugDocument)((Object)this.tabbedPane.getComponentAt(i));
            if (this.handler.documentClosing(document)) {
                document.closing();
                System.gc();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            ErrorManager.notify(e);
            return false;
        }
    }

    public JNodeCommanderAppLayoutHandler getHandler() {
        return this.handler;
    }

    public void setHandler(JNodeCommanderAppLayoutHandler handler) {
        this.handler = handler;
    }
}

