/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.filesystem;

import com.browsersoft.commander.commanderwindow.filesystem.actions.LocalFilePublicType;
import com.browsersoft.commander.model.DocumentManager;
import com.browsersoft.commander.model.adapter.AdapterItem;
import com.browsersoft.commander.model.adapter.Column;
import com.browsersoft.commander.model.adapter.ColumnName;
import com.browsersoft.commander.model.adapter.ColumnPosition;
import com.browsersoft.commander.model.adapter.ColumnRenderer;
import com.browsersoft.commander.model.adapter.ColumnSize;
import com.browsersoft.commander.model.adapter.renderer.DateCellRenderer;
import com.browsersoft.commander.model.adapter.renderer.SpacedNumberCellRenderer;
import com.browsersoft.commander.model.plugin.PublicTypeCollection;
import com.browsersoft.commander.utils.FileUtils;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class FileAdapterItem
extends AdapterItem {
    private File file;

    public FileAdapterItem(File file, DocumentManager documentManager) {
        this.file = file;
        Icon icon = documentManager.getIconForExtension(FileUtils.getExtension(file.getName()));
        if (icon == null) {
            icon = new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/filesystem/file.png"));
        }
        this.setIcon(icon);
    }

    @Override
    public String getId() {
        return this.file.getAbsolutePath();
    }

    @Override
    public String getName() {
        return FileUtils.getFileNameWithoutExtension(this.file.getName());
    }

    @Override
    public String getNameForPath() {
        return this.file.getName();
    }

    @Column
    @ColumnPosition(value=0)
    @ColumnSize(value=50)
    @ColumnName(value="Extension")
    public String getExtension() {
        return FileUtils.getExtension(this.file.getName());
    }

    @Column
    @ColumnPosition(value=1)
    @ColumnSize(value=70)
    @ColumnName(value="Size")
    @ColumnRenderer(value=SpacedNumberCellRenderer.class)
    public long getSize() {
        return this.file.length();
    }

    @Column
    @ColumnPosition(value=2)
    @ColumnSize(value=70)
    @ColumnName(value="Date")
    @ColumnRenderer(value=DateCellRenderer.class)
    public long getDate() {
        return this.file.lastModified();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public PublicTypeCollection getPublicTypeCollection() {
        PublicTypeCollection publicTypeCollection = new PublicTypeCollection();
        publicTypeCollection.add(new LocalFilePublicType(this.file));
        return publicTypeCollection;
    }
}

