/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.filesystem.actions;

import com.browsersoft.commander.commanderwindow.filesystem.DirectoryAdapterItem;
import com.browsersoft.commander.model.DirectoryFlavour;
import com.browsersoft.commander.model.DirectoryFlavourElement;
import com.browsersoft.commander.model.FlavouredItem;
import com.browsersoft.commander.model.OperationWorkerHandler;
import com.browsersoft.commander.model.adapter.ActionUtils;
import com.browsersoft.commander.model.adapter.AdapterPath;
import com.browsersoft.commander.model.adapter.SimpleImportAdapterAction;
import java.io.File;
import java.io.FileOutputStream;

public class DirectoryImportAction
extends SimpleImportAdapterAction {
    @Override
    public String getFlavourType() {
        return "com.browsersoft.commander.model.DirectoryFlavour";
    }

    @Override
    public void importItem(FlavouredItem item, AdapterPath path, OperationWorkerHandler handler) throws Exception {
        DirectoryFlavourElement element;
        DirectoryFlavour flavour = (DirectoryFlavour)item.getSelectedFlavourAsObject();
        while ((element = flavour.getNextElement()) != null) {
            if (element.getType() == 0) {
                File dir = this.getDestinationFile(item, path, element.getRelativePath());
                handler.operationElementStarting("Creating directory " + dir.getAbsolutePath(), "");
                if (dir.exists() || dir.mkdir()) continue;
                handler.operationError("It is not possible to create directory " + path);
                return;
            }
            File outputFile = this.getDestinationFile(item, path, element.getRelativePath());
            handler.operationElementStarting(item.getPathInSource() + "\\" + element.getRelativePath(), outputFile.getAbsolutePath());
            ActionUtils.inputStreamToOutputStreamWithHandler(element.openInputStream(), new FileOutputStream(outputFile), handler, element.getSize());
        }
    }

    @Override
    public boolean existItem(FlavouredItem item, AdapterPath path) throws Exception {
        return this.getDestinationFile(item, path, "").exists();
    }

    private File getDestinationFile(FlavouredItem item, AdapterPath path, String relative) {
        return new File(((DirectoryAdapterItem)path.getLast()).getFile().getAbsolutePath() + "/" + item.getNewName() + "/" + relative);
    }
}

