/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.filesystem.actions;

import com.browsersoft.commander.commanderwindow.filesystem.DirectoryAdapterItem;
import com.browsersoft.commander.commanderwindow.filesystem.FileAdapterItem;
import com.browsersoft.commander.commanderwindow.filesystem.actions.LocalDirectoryFlavour;
import com.browsersoft.commander.commanderwindow.filesystem.actions.LocalFileFlavour;
import com.browsersoft.commander.model.FlavouredItem;
import com.browsersoft.commander.model.adapter.AdapterItem;
import com.browsersoft.commander.model.adapter.SimpleExportAdapterAction;

public class FilesAndDirectoriesExportAction
extends SimpleExportAdapterAction {
    @Override
    public boolean checkItem(AdapterItem item) {
        return item instanceof FileAdapterItem || item instanceof DirectoryAdapterItem;
    }

    @Override
    public FlavouredItem exportItem(AdapterItem item) throws Exception {
        if (item instanceof FileAdapterItem) {
            return this.createFileFlavouredItem((FileAdapterItem)item);
        }
        if (item instanceof DirectoryAdapterItem) {
            return this.createDirectoryFlavouredItem((DirectoryAdapterItem)item);
        }
        return null;
    }

    private FlavouredItem createFileFlavouredItem(FileAdapterItem item) {
        FlavouredItem newFlavouredItem = new FlavouredItem();
        newFlavouredItem.setName(item.getFile().getName());
        newFlavouredItem.setPathInSource(item.getFile().getAbsolutePath());
        LocalFileFlavour flavour = new LocalFileFlavour(item.getFile());
        newFlavouredItem.add(flavour);
        return newFlavouredItem;
    }

    private FlavouredItem createDirectoryFlavouredItem(DirectoryAdapterItem item) throws Exception {
        FlavouredItem newFlavouredItem = new FlavouredItem();
        newFlavouredItem.setName(item.getFile().getName());
        newFlavouredItem.setPathInSource(item.getFile().getAbsolutePath());
        LocalDirectoryFlavour flavour = new LocalDirectoryFlavour(item.getFile());
        newFlavouredItem.add(flavour);
        return newFlavouredItem;
    }
}

