/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.filesystem.actions;

import com.browsersoft.commander.commanderwindow.filesystem.actions.LocalDirectoryFlavourElement;
import com.browsersoft.commander.model.DirectoryFlavour;
import com.browsersoft.commander.model.DirectoryFlavourElement;
import com.browsersoft.commander.model.PreparingHandler;
import com.browsersoft.commander.utils.DirectoryListStream;
import java.io.File;

public class LocalDirectoryFlavour
extends DirectoryFlavour {
    private int numberOfElements;
    DirectoryListStream directoryListStream;
    private boolean first;
    private File root;

    public LocalDirectoryFlavour(File root) {
        this.root = root;
    }

    @Override
    public void prepare(PreparingHandler handler) throws Exception {
        if (handler != null) {
            handler.prepareElementStarting(true, "Creating list for directory \"" + this.root + "\"");
        }
        DirectoryListStream streamForNumber = new DirectoryListStream(this.root);
        this.numberOfElements = 1;
        File f = streamForNumber.next();
        while (f != null) {
            ++this.numberOfElements;
            handler.prepareElementRunning(0, this.numberOfElements + " items (" + f.getName() + ")");
            f = streamForNumber.next();
        }
        this.directoryListStream = new DirectoryListStream(this.root);
        this.first = true;
    }

    @Override
    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    @Override
    public DirectoryFlavourElement getNextElement() {
        if (this.first) {
            this.first = false;
            return this.createItem(this.root);
        }
        File file = this.directoryListStream.next();
        if (file != null) {
            return this.createItem(file);
        }
        return null;
    }

    private LocalDirectoryFlavourElement createItem(File file) {
        int len = this.root.getAbsolutePath().length();
        String relativePath = file.getAbsolutePath().substring(len);
        return new LocalDirectoryFlavourElement(file, relativePath);
    }

    @Override
    public String getName() {
        return this.root.getName();
    }

    @Override
    public boolean hasLongPreparing() {
        return true;
    }
}

