/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.filesystem.actions;

import com.browsersoft.commander.model.DirectoryFlavourElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class LocalDirectoryFlavourElement
implements DirectoryFlavourElement {
    private File file;
    private String relativePath;

    public LocalDirectoryFlavourElement(File file, String relativePath) {
        this.file = file;
        this.relativePath = relativePath;
    }

    @Override
    public InputStream openInputStream() throws Exception {
        if (this.file.isFile()) {
            return new FileInputStream(this.file);
        }
        return null;
    }

    @Override
    public int getType() {
        if (this.file.isDirectory()) {
            return 0;
        }
        return 1;
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }
}

