/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.modules;

import com.browsersoft.commander.commanderwindow.error.ErrorManager;
import com.browsersoft.commander.commanderwindow.modules.ModuleInfo;
import com.browsersoft.commander.commanderwindow.modules.ModulesManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class ModulePanel
extends JPanel {
    private ModuleInfo moduleInfo;
    private String id;
    private String[] jars;
    private String[] classNames;
    private ModulesManager manager;
    private JButton buttonCheckUpdates;
    private JButton buttonCleanUpdate;
    private JCheckBox checkAutoUpdates;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel lblAutoConnect;
    private JLabel lblProfileName;
    private JLabel lblTypeOfStorage;
    private JTextField textName;
    private JPasswordField txtPassword;
    private JTextField txtURL;
    private JTextField txtUser;

    public ModulePanel(ModulesManager manager) {
        this.initComponents();
        this.manager = manager;
    }

    public void load(ModuleInfo moduleInfo) throws Exception {
        this.textName.setText(moduleInfo.getName());
        this.txtURL.setText(moduleInfo.getUrl());
        this.txtUser.setText(moduleInfo.getUser());
        this.txtPassword.setText(moduleInfo.getPassword());
        this.checkAutoUpdates.setSelected(moduleInfo.isAutoCheckUpdate());
        this.classNames = moduleInfo.getClassNames();
        this.jars = moduleInfo.getJars();
        this.id = moduleInfo.getId();
    }

    public ModuleInfo save() {
        ModuleInfo moduleInfo = new ModuleInfo();
        moduleInfo.setName(this.textName.getText());
        moduleInfo.setUrl(this.txtURL.getText());
        moduleInfo.setUser(this.txtUser.getText());
        moduleInfo.setPassword(String.valueOf(this.txtPassword.getPassword()));
        moduleInfo.setAutoCheckUpdate(this.checkAutoUpdates.isSelected());
        moduleInfo.setId(this.id);
        moduleInfo.setJars(this.jars);
        moduleInfo.setClassName(this.classNames);
        return moduleInfo;
    }

    private void initComponents() {
        this.textName = new JTextField();
        this.lblProfileName = new JLabel();
        this.lblTypeOfStorage = new JLabel();
        this.checkAutoUpdates = new JCheckBox();
        this.lblAutoConnect = new JLabel();
        this.txtURL = new JTextField();
        this.jLabel1 = new JLabel();
        this.txtUser = new JTextField();
        this.jLabel2 = new JLabel();
        this.txtPassword = new JPasswordField();
        this.buttonCheckUpdates = new JButton();
        this.buttonCleanUpdate = new JButton();
        this.lblProfileName.setText("Profile name:");
        this.lblTypeOfStorage.setText("URL:");
        this.checkAutoUpdates.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkAutoUpdates.setMargin(new Insets(0, 0, 0, 0));
        this.lblAutoConnect.setText("Auto check updates:");
        this.jLabel1.setText("User:");
        this.jLabel2.setText("Password:");
        this.buttonCheckUpdates.setText("Check updates");
        this.buttonCheckUpdates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModulePanel.this.buttonCheckUpdatesActionPerformed(evt);
            }
        });
        this.buttonCleanUpdate.setText("Clean & update");
        this.buttonCleanUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModulePanel.this.buttonCleanUpdateActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1, -1, 142, Short.MAX_VALUE).add((Component)this.lblTypeOfStorage).add((Component)this.lblProfileName)).addPreferredGap(0)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).add(59, 59, 59))).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.txtPassword, -1, 419, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.checkAutoUpdates).addPreferredGap(0, 157, Short.MAX_VALUE).add((Component)this.buttonCleanUpdate, -2, 129, -2).add(17, 17, 17).add((Component)this.buttonCheckUpdates)).add((Component)this.txtURL, -1, 419, Short.MAX_VALUE).add((Component)this.textName, -1, 419, Short.MAX_VALUE).add((Component)this.txtUser, -1, 419, Short.MAX_VALUE)).addContainerGap(38, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lblAutoConnect, -1, -1, Short.MAX_VALUE).add(504, 504, 504)))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(29, 29, 29).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblProfileName).add((Component)this.textName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblTypeOfStorage).add((Component)this.txtURL, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.txtUser, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.txtPassword, -2, -1, -2)).add(20, 20, 20).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.lblAutoConnect).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.buttonCheckUpdates).add((Component)this.buttonCleanUpdate)))).add(2, (Component)this.checkAutoUpdates)).addContainerGap(29, Short.MAX_VALUE)));
    }

    private void buttonCleanUpdateActionPerformed(ActionEvent evt) {
        try {
            ModuleInfo info = this.save();
            this.manager.cleanModule(info);
            this.manager.updateModule(info);
            this.load(info);
        }
        catch (Exception e) {
            ErrorManager.notify(e);
        }
    }

    private void buttonCheckUpdatesActionPerformed(ActionEvent evt) {
        try {
            ModuleInfo info = this.save();
            this.manager.updateModule(info);
            this.load(info);
        }
        catch (Exception e) {
            ErrorManager.notify(e);
        }
    }
}

