/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.modules;

import com.browsersoft.commander.commanderwindow.modules.DownloadUpdatesDialog;
import com.browsersoft.commander.commanderwindow.modules.ModuleInfo;
import com.browsersoft.commander.commanderwindow.modules.ModuleInfoCollection;
import com.browsersoft.commander.commanderwindow.modules.download.JarInfo;
import com.browsersoft.commander.commanderwindow.modules.download.JarInfoCollection;
import com.browsersoft.commander.commanderwindow.modules.download.Module;
import com.browsersoft.commander.commanderwindow.modules.download.ModuleDownloader;
import com.browsersoft.commander.commanderwindow.settings.CommanderSettings;
import com.browsersoft.commander.utils.FileUtils;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;

public class ModulesManager {
    private CommanderSettings commanderSettings;
    private Frame frame;

    public void updateModules(ModuleInfoCollection moduleCollection, boolean all) throws Exception {
        for (int i = 0; i < moduleCollection.size(); ++i) {
            ModuleInfo info = moduleCollection.get(i);
            if (!info.isAutoCheckUpdate() && !all) continue;
            try {
                this.updateModule(info);
            }
            catch (Exception e) {
                System.out.println("It is not possible to download module \"" + info.getName() + "\"");
            }
            this.commanderSettings.saveModules(moduleCollection);
        }
        this.commanderSettings.saveModules(moduleCollection);
    }

    public void cleanModule(ModuleInfo moduleInfo) throws Exception {
        System.gc();
        File dirForModule = this.getTempDirectoryForModule(moduleInfo);
        File[] files = dirForModule.listFiles();
        String[] jars = moduleInfo.getJars();
        for (File file : files) {
            if (!file.isFile()) continue;
            boolean isInside = false;
            for (String jar : jars) {
                if (!FileUtils.getFileNameWithoutExtension(file.getName()).equals(jar)) continue;
                isInside = true;
            }
            if (isInside) continue;
            System.out.println(file.delete());
        }
    }

    public void updateModule(ModuleInfo moduleInfo) throws Exception {
        ModuleDownloader downloader = new ModuleDownloader();
        Module module = downloader.downloadModule(moduleInfo.getUrl(), moduleInfo.getUser(), moduleInfo.getPassword());
        File dirForModule = this.getTempDirectoryForModule(moduleInfo);
        this.updateModuleFromDirectory(dirForModule, module);
        if (module.needDownload()) {
            DownloadUpdatesDialog pd = new DownloadUpdatesDialog(this.frame, true);
            downloader.setModule(module);
            downloader.setUser(moduleInfo.getUser());
            downloader.setPassword(moduleInfo.getPassword());
            try {
                pd.centerParent();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pd.setWorkerAndRun(downloader);
            pd.setVisible(true);
            if (pd.isCanceled()) {
                // empty if block
            }
        }
        moduleInfo.setJars(module.getJars().toJars());
        moduleInfo.setClassName(module.getClassNames().toClassNames());
        this.cleanModule(moduleInfo);
    }

    public File getTempDirectoryForModule(ModuleInfo moduleInfo) throws IOException, ClassNotFoundException {
        File dirForModule = new File(this.commanderSettings.getTempDir() + "/" + moduleInfo.getId());
        if (!dirForModule.exists()) {
            dirForModule.mkdir();
        }
        return dirForModule;
    }

    private void updateModuleFromDirectory(File dir, Module module) {
        JarInfoCollection jars = module.getJars();
        for (int i = 0; i < jars.size(); ++i) {
            JarInfo info = jars.get(i);
            info.setFile(new File(dir.getAbsolutePath() + "/" + info.getId() + ".jar"));
        }
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public CommanderSettings getCommanderSettings() {
        return this.commanderSettings;
    }

    public void setCommanderSettings(CommanderSettings commanderSettings) {
        this.commanderSettings = commanderSettings;
    }
}

