/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.modules;

import com.browsersoft.commander.commanderwindow.error.ErrorManager;
import com.browsersoft.commander.commanderwindow.modules.ModuleInfo;
import com.browsersoft.commander.commanderwindow.modules.ModuleInfoCollection;
import com.browsersoft.commander.commanderwindow.modules.ModulePanel;
import com.browsersoft.commander.commanderwindow.modules.ModulesManager;
import com.browsersoft.commander.commanderwindow.modules.StorageTypeInfoCollection;
import com.browsersoft.commander.model.DocumentManager;
import com.browsersoft.commander.utils.swing.CenteredDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.jdesktop.layout.GroupLayout;

public class ModulesPanel
extends CenteredDialog {
    private StorageTypeInfoCollection storageTypes;
    private ModuleInfoCollection modules;
    private DocumentManager documentManager;
    private ModulesManager manager;
    private JButton buttonAdd;
    private JButton buttonCancel;
    private JButton buttonDelete;
    private JButton buttonExport;
    private JButton buttonImport;
    private JButton buttonOK;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTabbedPane tabBar;
    private JToolBar toolbar;
    private JTextField txtTempDirectory;

    public ModulesPanel(JFrame frame, boolean modal, ModulesManager manager) {
        super((Frame)frame, modal);
        this.initComponents();
        this.manager = manager;
    }

    public void loadTempDir(String temp) throws Exception {
        this.txtTempDirectory.setText(temp);
    }

    public String saveTempDir() {
        return this.txtTempDirectory.getText();
    }

    public void loadModules(ModuleInfoCollection modules) throws Exception {
        this.tabBar.removeAll();
        for (int i = 0; i < modules.size(); ++i) {
            ModuleInfo moduleInfo = modules.get(i);
            ModulePanel moduleForm = new ModulePanel(this.manager);
            moduleForm.load(moduleInfo);
            this.tabBar.addTab(moduleInfo.getName(), moduleForm);
        }
    }

    public ModuleInfoCollection saveModules() throws Exception {
        ModuleInfoCollection modules = new ModuleInfoCollection();
        int count = this.tabBar.getComponentCount();
        for (int i = 0; i < count; ++i) {
            ModulePanel item = (ModulePanel)this.tabBar.getComponent(i);
            modules.add(item.save());
        }
        return modules;
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.buttonOK = new JButton();
        this.buttonCancel = new JButton();
        this.jPanel1 = new JPanel();
        this.txtTempDirectory = new JTextField();
        this.jButton2 = new JButton();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.toolbar = new JToolBar();
        this.buttonAdd = new JButton();
        this.buttonDelete = new JButton();
        this.buttonExport = new JButton();
        this.buttonImport = new JButton();
        this.tabBar = new JTabbedPane();
        this.jButton1.setText("jButton1");
        this.setTitle("Modules");
        this.setResizable(false);
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModulesPanel.this.buttonOKActionPerformed(evt);
            }
        });
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModulesPanel.this.buttonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Settings", 0, 0, new Font("Tahoma", 0, 11), new Color(153, 153, 153)));
        this.jButton2.setText("Browse");
        this.jLabel1.setText("Directory for downloaded modules:");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.txtTempDirectory, -1, 579, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButton2)).add((Component)this.jLabel1)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).add(15, 15, 15).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jButton2).add((Component)this.txtTempDirectory, -1, 26, Short.MAX_VALUE)).add(28, 28, 28)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Modules", 0, 0, new Font("Tahoma", 0, 11), new Color(153, 153, 153)));
        this.buttonAdd.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/profiles/add.png")));
        this.buttonAdd.setText("Add");
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModulesPanel.this.buttonAddActionPerformed(evt);
            }
        });
        this.toolbar.add(this.buttonAdd);
        this.buttonDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/profiles/remove.png")));
        this.buttonDelete.setText("Delete");
        this.buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModulesPanel.this.buttonDeleteActionPerformed(evt);
            }
        });
        this.toolbar.add(this.buttonDelete);
        this.buttonExport.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/profiles/export.png")));
        this.buttonExport.setText("Export");
        this.buttonExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModulesPanel.this.buttonExportActionPerformed(evt);
            }
        });
        this.buttonImport.setIcon(new ImageIcon(this.getClass().getResource("/com/browsersoft/commander/commanderwindow/profiles/import.png")));
        this.buttonImport.setText("Import");
        this.buttonImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModulesPanel.this.buttonImportActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.tabBar, -1, 652, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.toolbar, -1, 582, Short.MAX_VALUE).add(80, 80, 80)))));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.toolbar, -2, 25, -2).addPreferredGap(0).add((Component)this.tabBar, -2, 252, -2).addContainerGap(20, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.buttonCancel).addPreferredGap(0).add((Component)this.buttonOK))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).add(14, 14, 14).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.buttonCancel).add((Component)this.buttonOK)).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        try {
            this.saveModules();
        }
        catch (Exception ex) {
            ErrorManager.notify(ex);
        }
        this.dispose();
    }

    private void buttonImportActionPerformed(ActionEvent evt) {
    }

    private void buttonExportActionPerformed(ActionEvent evt) {
    }

    private void buttonDeleteActionPerformed(ActionEvent evt) {
        ModulePanel panel = (ModulePanel)this.tabBar.getComponentAt(this.tabBar.getSelectedIndex());
        this.tabBar.remove(this.tabBar.getSelectedIndex());
    }

    private void buttonAddActionPerformed(ActionEvent evt) {
        try {
            ModuleInfo defaultModule = new ModuleInfo();
            defaultModule.setName("New module");
            defaultModule.setId(UUID.randomUUID().toString());
            ModulePanel moduleForm = new ModulePanel(this.manager);
            moduleForm.load(defaultModule);
            this.tabBar.addTab(defaultModule.getName(), moduleForm);
        }
        catch (Exception e) {
            ErrorManager.notify(e);
        }
    }
}

