/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.modules;

import com.browsersoft.commander.commanderwindow.error.DefaultErrorNotifier;
import com.browsersoft.commander.commanderwindow.error.ErrorManager;
import com.browsersoft.commander.commanderwindow.modules.BuildInPluginsManager;
import com.browsersoft.commander.commanderwindow.modules.ModuleInfo;
import com.browsersoft.commander.commanderwindow.modules.ModuleInfoCollection;
import com.browsersoft.commander.commanderwindow.modules.ModulesManager;
import com.browsersoft.commander.commanderwindow.modules.StorageTypeInfo;
import com.browsersoft.commander.model.CommanderPlugStorage;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class StorageTypeInfoCollection {
    public static final String PLUGIN_TAG_NAME = "plugin";
    public static final String PLUGIN_TAG_CLASS_PARAMETER = "class";
    public static final String PROFILES_PREFIX_PARAMETER = "profilesPrefix";
    private ArrayList<StorageTypeInfo> objects = new ArrayList();
    public static final String ATTRIBUTE_MODEL = "JNodeCommander-Storage";

    public void add(StorageTypeInfo item) {
        this.objects.add(item);
    }

    public StorageTypeInfo get(int index) {
        return this.objects.get(index);
    }

    public void clear() {
        this.objects.clear();
    }

    public int size() {
        return this.objects.size();
    }

    public List<ClassLoader> getClassLoaders() {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        for (StorageTypeInfo typeInfo : this.objects) {
            classLoaders.add(typeInfo.getStorage().getClass().getClassLoader());
        }
        return classLoaders;
    }

    public void reinitStorages(ModuleInfoCollection modules, ModulesManager modulesManager) throws Exception {
        this.clear();
        Set<CommanderPlugStorage> storagePlugins = BuildInPluginsManager.getPlugins(CommanderPlugStorage.class);
        for (CommanderPlugStorage storagePlugin : storagePlugins) {
            try {
                storagePlugin.setErrorNotifier(new DefaultErrorNotifier());
                StorageTypeInfo storageTypeInfo = new StorageTypeInfo();
                storageTypeInfo.setStorage(storagePlugin);
                this.add(storageTypeInfo);
            }
            catch (Exception storageTypeInfo) {}
        }
        for (int i = 0; i < modules.size(); ++i) {
            try {
                String[] classes;
                ModuleInfo info = modules.get(i);
                ClassLoader classLoader = info.toClassLoader(modulesManager.getTempDirectoryForModule(info).getAbsolutePath());
                for (String classname : classes = info.getClassNames()) {
                    Class<?> modelClass = classLoader.loadClass(classname);
                    Constructor<?> constructor = modelClass.getConstructors()[0];
                    CommanderPlugStorage newStorage = (CommanderPlugStorage)constructor.newInstance(new Object[0]);
                    newStorage.setJars(this.getJarFiles(info.getJars(), modulesManager.getTempDirectoryForModule(info).getAbsolutePath()));
                    newStorage.setFullStorageName(info.getName() + " - " + newStorage.getStorageName());
                    System.out.println("Module \"" + newStorage.getFullStorageName() + "\" detected");
                    newStorage.setErrorNotifier(new DefaultErrorNotifier());
                    StorageTypeInfo storageTypeInfo = new StorageTypeInfo();
                    storageTypeInfo.setStorage(newStorage);
                    this.add(storageTypeInfo);
                }
                continue;
            }
            catch (Exception e) {
                ErrorManager.notify(e);
            }
        }
    }

    public File[] getJarFiles(String[] jars, String root) {
        File[] urls = new File[jars.length];
        for (int i = 0; i < jars.length; ++i) {
            File file;
            urls[i] = file = new File(root + "/" + jars[i] + ".jar");
        }
        return urls;
    }
}

