/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.modules.download;

import com.browsersoft.commander.commanderwindow.modules.download.JarInfo;
import com.browsersoft.commander.commanderwindow.modules.download.Module;
import com.browsersoft.commander.commanderwindow.modules.download.ModuleDownloaderHandler;
import com.browsersoft.commander.utils.DOMUtils;
import com.browsersoft.commander.utils.FileUtils;
import com.browsersoft.commander.utils.StreamUtils;
import com.browsersoft.commander.utils.http.HttpLogin;
import com.browsersoft.commander.utils.http.HttpUtilsHandler;
import com.browsersoft.commander.utils.swing.SwingWorker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModuleDownloader
extends SwingWorker
implements HttpUtilsHandler {
    private ModuleDownloaderHandler handler;
    private Module module;
    private String user;
    private String password;
    private boolean stop;

    @Override
    public Object construct() {
        try {
            HttpLogin login = new HttpLogin(this.user, this.password);
            int numberOfAll = 0;
            for (int i = 0; i < this.module.getJars().size(); ++i) {
                JarInfo jarInfo = this.module.getJars().get(i);
                if (jarInfo.getFile().exists()) continue;
                ++numberOfAll;
            }
            int counter = 0;
            for (int i = 0; i < this.module.getJars().size(); ++i) {
                if (this.stop) continue;
                JarInfo jarInfo = this.module.getJars().get(i);
                if (!jarInfo.getFile().exists()) {
                    int percent = (int)Math.ceil((double)counter / (double)numberOfAll * 100.0);
                    ++counter;
                    this.handler.processAll(percent, "Update module \"" + this.module.getName() + "\"", "Downloading " + jarInfo.getUrl());
                    File tempFile = new File(FileUtils.getFileNameWithoutExtension(jarInfo.getFile().getAbsolutePath()) + ".downloading");
                    if (!tempFile.exists() || !tempFile.delete()) {
                        // empty if block
                    }
                    if (jarInfo.getUrl().startsWith("file:///")) {
                        String url = jarInfo.getUrl().substring("file:///".length());
                        StreamUtils.inputStreamToOutputStream(new FileInputStream(url), new FileOutputStream(jarInfo.getFile()));
                    }
                }
                if (!Thread.interrupted()) continue;
                return null;
            }
        }
        catch (Exception e) {
            this.handler.procesError(e);
            return null;
        }
        this.handler.procesFinish();
        return null;
    }

    public Module downloadModule(String url, String user, String password) throws Exception {
        Module module = new Module();
        HttpLogin login = new HttpLogin(user, password);
        String xml = this.downloadFromURL(url, login, "UTF-8", false);
        Document document = DOMUtils.loadFromString(xml);
        Element root = document.getDocumentElement();
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node child = root.getChildNodes().item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals("class")) {
                module.getClassNames().add(DOMUtils.getTextContent(child));
                continue;
            }
            if (child.getNodeName().equals("name")) {
                module.setName(DOMUtils.getTextContent(child));
                continue;
            }
            if (!child.getNodeName().equals("jar")) continue;
            JarInfo jarInfo = new JarInfo();
            String path = DOMUtils.getTextContent(child);
            String dir = FileUtils.getDirectoryFromURL(url);
            jarInfo.setUrl(dir + path);
            String pathTomd5 = path + ".MD5";
            String md5code = this.downloadFromURL(dir + pathTomd5, login, "UTF-8", false);
            jarInfo.setId(md5code);
            module.getJars().add(jarInfo);
        }
        return module;
    }

    private String downloadFromURL(String url, HttpLogin login, String encoding, boolean debug) throws Exception {
        if (url.startsWith("file:///")) {
            String newurl = url.substring("file:///".length());
            return DOMUtils.loadFileToStringWithEncoding(newurl, encoding).trim();
        }
        return null;
    }

    public ModuleDownloaderHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ModuleDownloaderHandler handler) {
        this.handler = handler;
    }

    @Override
    public boolean downloadRunning(int i) {
        this.handler.processItem(i);
        return !this.stop;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }
}

