/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.paths;

import com.browsersoft.commander.commanderwindow.paths.HotDirectoryListItem;
import com.browsersoft.commander.utils.StreamUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;

public class PathsNode {
    Preferences preferences = Preferences.userNodeForPackage(this.getClass());

    public List<String> getPath(String name) throws IOException, ClassNotFoundException {
        byte[] bytes = this.preferences.getByteArray(name, null);
        if (bytes == null) {
            return null;
        }
        return (List)StreamUtils.deserializeByteArrayToObject(bytes);
    }

    public void setPath(String name, List<String> path) throws IOException {
        this.preferences.putByteArray(name, StreamUtils.serializeObjectToByteArray(path));
    }

    public List<HotDirectoryListItem> getHotlist() throws ClassNotFoundException, IOException {
        int size = this.preferences.getInt("hotlist_count", 0);
        ArrayList<HotDirectoryListItem> list = new ArrayList<HotDirectoryListItem>();
        for (int i = 0; i < size; ++i) {
            byte[] bytes = this.preferences.getByteArray("hotlist_" + i, null);
            if (bytes == null) continue;
            list.add((HotDirectoryListItem)StreamUtils.deserializeByteArrayToObject(bytes));
        }
        return list;
    }

    public void setHotlist(List<HotDirectoryListItem> hotlist) throws IOException {
        this.preferences.putInt("hotlist_count", hotlist.size());
        for (int i = 0; i < hotlist.size(); ++i) {
            this.preferences.putByteArray("hotlist_" + i, StreamUtils.serializeObjectToByteArray(hotlist.get(i)));
        }
    }
}

