/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.commanderwindow.plugin.zip;

import com.browsersoft.commander.commanderwindow.plugin.zip.BrowserZipAdapterItemCollection;
import com.browsersoft.commander.commanderwindow.plugin.zip.ZipEntryDirectoryAdapterItem;
import com.browsersoft.commander.commanderwindow.plugin.zip.ZipEntryExportDirectoryAndFileAction;
import com.browsersoft.commander.commanderwindow.plugin.zip.ZipEntryFileAdapterItem;
import com.browsersoft.commander.commanderwindow.plugin.zip.ZipUtils;
import com.browsersoft.commander.model.adapter.AdapterItemCollection;
import com.browsersoft.commander.model.adapter.AdapterPath;
import com.browsersoft.commander.model.adapter.CommanderAdapter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BrowserZipFilePluginAdapter
extends CommanderAdapter {
    private ZipFile zf;
    private File file;

    public BrowserZipFilePluginAdapter(File file) throws IOException {
        this.zf = new ZipFile(file);
        this.file = file;
    }

    @Override
    public AdapterItemCollection go(AdapterPath path) throws Exception {
        if (path.size() == 0) {
            return this.getListOfDir("");
        }
        if (path.getLast() instanceof ZipEntryDirectoryAdapterItem) {
            ZipEntryDirectoryAdapterItem item = (ZipEntryDirectoryAdapterItem)path.getLast();
            return this.getListOfDir(item.getZipEntry().getName());
        }
        if (path.getLast() instanceof ZipEntryFileAdapterItem) {
            ZipEntryFileAdapterItem item = (ZipEntryFileAdapterItem)path.getLast();
            this.getDocumentManager().copyToTempAndOpenInSystem(new ZipEntryExportDirectoryAndFileAction(this.file, this.zf).exportItem(item));
            return null;
        }
        return null;
    }

    private AdapterItemCollection getListOfDir(String path) {
        List<ZipEntry> entries = ZipUtils.getZipEntriesInEntry(this.zf, path);
        BrowserZipAdapterItemCollection collection = new BrowserZipAdapterItemCollection();
        for (ZipEntry inEntry : entries) {
            if (inEntry.isDirectory()) {
                collection.add(new ZipEntryDirectoryAdapterItem(inEntry));
                continue;
            }
            collection.add(new ZipEntryFileAdapterItem(inEntry, this.getDocumentManager(), this.file));
        }
        collection.addAction(new ZipEntryExportDirectoryAndFileAction(this.file, this.zf));
        return collection;
    }
}

